% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.trajectory.R
\name{plot.trajectory}
\alias{plot.trajectory}
\title{Plot Method for \code{trajectory} Objects}
\usage{
\method{plot}{trajectory}(x, engine = "dot",
  fill = scales::brewer_pal("qual"), verbose = FALSE, ...)
}
\arguments{
\item{x}{a simmer trajectory.}

\item{engine}{a string specifying a layout engine (see \code{\link[DiagrammeR]{grViz}}).}

\item{fill}{discrete color palette for resource identification.}

\item{verbose}{show additional info directly in the labels.}

\item{...}{additional parameters for \code{\link[DiagrammeR]{render_graph}}.}
}
\value{
Returns an \code{htmlwidget}.
}
\description{
A method for the \code{\link{plot}} generic that plots a diagram of the given trajectory.
}
\examples{
x <- trajectory() \%>\%
  seize("res", 1) \%>\%
  timeout(1) \%>\%
  release("res", 1) \%>\%
  rollback(3)

plot(x)
}
