% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{solve_ode}
\alias{solve_ode}
\title{Ordinary differential equations solver}
\usage{
solve_ode(equations, pars, x0, time, xvars = NULL, ...)
}
\arguments{
\item{equations}{The equations describing the ODE system. See \link{simode}.}

\item{pars}{The parameter values. Named according to their names in \code{equations}.}

\item{x0}{The initial conditions. Named accroding to the names of \code{equations}.}

\item{time}{The time points for which the ODE variables' values will be computed.}

\item{xvars}{External observations of time-dependant variables refered to in \code{equations}}

\item{...}{Additional argument(s) for methods.}
}
\value{
A matrix whose first column contains the given time points
and subsequent columns hold the computed ODE equations' values at these time points.
}
\description{
A wrapper for the \link[deSolve]{ode} function that solves a system of
ordinary differential equations described using symbolic equations.
}
