% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessories.R
\name{getExpectedAbund}
\alias{getExpectedAbund}
\title{Calculate expected abundance}
\usage{
getExpectedAbund(
  featureMetadata,
  times = NULL,
  sampleMetadata = NULL,
  byCondGroup = is.null(times)
)
}
\arguments{
\item{featureMetadata}{\code{data.table} with columns \code{feature}, \code{base},
\code{rhyFunc}, \code{amp}, \code{period}, and \code{phase}, where every row corresponds to a
gene. If \code{byCondGroup} is \code{TRUE}, then must also have columns \code{cond} and
\code{group}.}

\item{times}{Numeric vector of the times at which to calculate expected
abundance for each row in \code{featureMetadata}.}

\item{sampleMetadata}{\code{data.table} with columns \code{sample}, \code{cond}, and
\code{time}. Either \code{times} or \code{sampleMetadata} must be provided, and the former
takes precedence.}

\item{byCondGroup}{Logical for whether to speed up the calculation by
grouping by the columns \code{cond} and \code{group}. Primarily for internal use.}
}
\value{
\code{data.table} derived from \code{featureMetadata} (but with more rows),
with additional columns \code{time} and \code{mu} and possibly others. If sampling
will use the negative binomial family, \code{mu} corresponds to log2 counts.
}
\description{
Calculate expected abundance for multiple features at multiple timepoints in
multiple conditions.
}
\examples{
library('data.table')
featureMetadata = data.table(feature = c('feature_1', 'feature_2'),
                             base = function(x) 0,
                             amp = c(function(x) 0, function(x) 1),
                             period = 24,
                             phase = 0, rhyFunc = sin)
abundDt = getExpectedAbund(featureMetadata, times = 6:17)

}
\seealso{
\code{\link[=simphony]{simphony()}}, \code{\link[=getSampledAbund]{getSampledAbund()}}
}
