% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simFDR.R
\name{simFDR}
\alias{simFDR}
\title{Simple False Discovery Rate (FDR) Calculation}
\usage{
simFDR(df, q = 0.05, sig_only = TRUE)
}
\arguments{
\item{df}{dataframe with variable names in column 1, and p values in column 2.  For dataframes with more than these 2 columns, the additional columns will be ignored.  Example: df<- data.frame("variable"= c("a","b","c","d","e","f","g","h","i","j","k"),"p_value" = c(0.04,0.03,0.04,0.02,0.03,0.02,0.02,0.01,0.04,0.1,0.02))}

\item{q}{user defined FDR threshold.  Defaults to 0.05.}

\item{sig_only}{logical value indicating whether to return just the variables that are significant, or all input variables.  If TRUE, only significant variables are returned.  If FALSE, all variables are returned with the significant variables at the top.  Defaults to TRUE.}
}
\value{
Returns the original dataframe with a significance column where an asterisk denotes a significant p value after FDR calculation, and NA denotes all other p values.
}
\description{
Using the Benjamini & Hochberg adjustment method, determine which variables are significant under repeated testing with a given dataframe of p values and an user defined "q" threshold.
}
\examples{
df <- data.frame("variable"= c("a","b","c","d","e"),"p_value" = c(0.04,0.03,0.04,0.02,0.03))

# defaults to q = 0.05 and shows only significant p values
FDR_values <- simFDR(df)

# q = 0.1 and shows only significant p values
FDR_values <- simFDR(df, q = 0.1)

# q = 0.05 and shows all p values, with significant p values at the top
FDR_values <- simFDR(df, sig_only = FALSE)
}
\references{
Lee, S., & Lee, D. K. (2018). What is the proper way to apply the multiple comparison test?. Korean journal of anesthesiology, 71(5), 353.

Benjamini, Y., & Hochberg, Y. (1995). Controlling the false discovery rate: a practical and powerful approach to multiple testing. Journal of the Royal statistical society: series B (Methodological), 57(1), 289-300.
}
\author{
Stephen C Wisser
}
