% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ToivonenBestPath.R
\name{bestpath}
\alias{bestpath}
\title{Sparsification via Best Path}
\usage{
bestpath(network, directed = FALSE, associative = TRUE)
}
\arguments{
\item{network}{Weighted adjacency matrix, weighted \code{igraph} network, or edge list formatted | n1 | n2 | weight | with colnames \code{c("n1", "n2", "weight")}.}

\item{directed}{If \code{TRUE}, specifies that the inputted network is directed. Default is \code{FALSE}.}

\item{associative}{Designates if the network is associative where edge weight determines "similarity" or "strength" or dissociative where edge weight denotes "dissimilarity" or "distance".\cr
If the network is associative, then the shortest path would be found by looking at \code{w_e^-1} where weaker association between nodes suggests a larger distance between nodes for shortest paths. \cr
If the network is dissociative, then the shortest path would be between \code{w_e}.}
}
\value{
Edge list of sparsified network via best path.
}
\description{
Calculates network sparsifier from best path
}
\examples{
#Generate random ER graph with uniformly random edge weights
g = igraph::erdos.renyi.game(50, 0.1)
igraph::E(g)$weight <- runif(length(igraph::E(g)))
#Sparsify g via bestpath
S = simplifyNet::bestpath(g, directed = FALSE, associative = TRUE) #Show edge list conversion
sg = simplifyNet::net.as(S, net.to="igraph", directed=FALSE)
igraph::ecount(sg)/igraph::ecount(g)#fraction of edges in the sparsifier
}
\references{
Toivonen, H., Mahler, S., & Zhou, F. (2010, May). A framework for path-oriented network simplification. In International Symposium on Intelligent Data Analysis (pp. 220-231). Springer, Berlin, Heidelberg.
}
\author{
Alexander Mercier

Andrew Kramer
}
