% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{get_factor_score_validity_se}
\alias{get_factor_score_validity_se}
\title{Return factor score validity coefficient standard errors}
\usage{
get_factor_score_validity_se(m, latent = TRUE, errors = FALSE, ...)
}
\arguments{
\item{m}{Structural model represented by lavaan syntax or output of sim_standardized_matrices function.}

\item{latent}{Include latent variables.}

\item{errors}{Include observed error and latent disturbances variables.}

\item{...}{parameters passed to the `sim_standardized_matrices` function}
}
\value{
A matrix of factor score standard errors
}
\description{
Return factor score validity coefficient standard errors
}
\examples{
m <- "
A =~ 0.5 * A1 + 0.8 * A2 + 0.8 * A3
B =~ 0.5 * B1 + 0.8 * B2 + 0.8 * B3
B ~ 0.5 * A
"
get_factor_score_validity_se(m)
}
