% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{evaluate_internal}
\alias{evaluate_internal}
\title{Evaluate outputs of methods according to provided metrics.}
\usage{
evaluate_internal(
  metrics,
  dir = ".",
  model_name,
  index,
  method_names,
  out_loc = "out"
)
}
\arguments{
\item{metrics}{a list of \code{\linkS4class{Metric}} objects or a single
\code{\linkS4class{Metric}} object}

\item{dir}{the directory where \code{\linkS4class{Model}} object was saved (by
\code{\link{generate_model}})}

\item{model_name}{the \code{\linkS4class{Model}} object's \code{name} attribute}

\item{index}{the index of a computed \code{\linkS4class{Draws}} object.  Can
alternately be a vector of such indices.}

\item{method_names}{the \code{\linkS4class{Method}} objects' \code{name} attributes
as a character vector.}

\item{out_loc}{(optional) a length-1 character vector that gives location
(relative to model's path) that method outputs are stored.}
}
\description{
Given a \code{\linkS4class{Metric}} object or list of \code{\linkS4class{Metric}} objects,
this function evaluates an \code{\linkS4class{Output}} object according to these
metrics.  The computed values of the metrics are saved to file.
}
\details{
This function creates objects of class \code{\linkS4class{Evals}} and saves each to
file (at dir/model_name/<out_loc>/r<index>_<method_name>_evals.Rdata. Since
evaluating metrics is usually (in statistical methodological papers) fast,
parallel functionality has not been developed for the evaluation component.
}
