% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-from-simulation.R
\name{subset_simulation}
\alias{subset_simulation}
\title{Create a simulation that is a subset of a preexisting simulation object}
\usage{
subset_simulation(sim, ..., subset = NULL, index, methods)
}
\arguments{
\item{sim}{a simulation object}

\item{...}{logical conditions to specify a subset of models.  Conditions can
only involve params of model that have length 1 and are of class
numeric or character.}

\item{subset}{a vector of integers indexing the models or a vector of model
names. To select models based on parameter values, use \code{...}.
However, using \code{...} is slower than using subset.}

\item{index}{a vector of positive integers specifying which draws' objects
are desired. If missing, then all draws' evals are returned.}

\item{methods}{character vector of method names of interest.  If missing,
then all methods' evals are returned}
}
\description{
Given a simulation, creates a new simulation that is a subset of the
preexisting simulation.  Does not save this new one to file.  To do so,
first change the name (and, potentially, label) of the simulation
and then use \code{\link{save_simulation}}.  If you call
\code{\link{save_simulation}} before changing the name, you will overwrite
the preexisting simulation.  Use \code{\link{rename}} and
\code{\link{relabel}}.
}
