% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cls_sinar.R
\name{cls}
\alias{cls}
\title{Conditional least square estimates for a SINAR(1,1)  process.}
\usage{
cls(X)
}
\arguments{
\item{X}{A integer matrix where each cell is the observed value in the
regular lattice.}
}
\value{
a vector with the estimates of \eqn{a_{10}, a_{01}, a_{11}, \mu}.
}
\description{
\code{cls} computes the conditional least square for a process described
by
\deqn{X_{i,j}= a_{10} X_{i-1,j} + a_{01} X_{i,j-1} + a_{11} X_{i-1, j-1} +
 \epsilon_{i,j}}
where \eqn{\epsilon_{i,j}} is an iid process with poison distribution. Note
the \eqn{a_{10}, a_{01}, a_{11}} must belong to the interval \eqn{[0,1]}.
We obtain estimates for \eqn{a_{10}, a_{01}, a_{11}} and \eqn{\mu_\epsilon}.
We do not make any asumption about the distribution of the innovation in the
process.
}
\examples{

data("nematodes")
cls(nematodes)
}
