% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeImport.R
\name{update_desc}
\alias{update_desc}
\title{Update Package Description File}
\usage{
update_desc(path, overwrite = TRUE)
}
\arguments{
\item{path}{character, path to R folder containing package functions}

\item{overwrite}{logical, overwrite the file, Default: TRUE}
}
\description{
Update package DESCRIPTION file Imports field
}
\details{
If overwrite is FALSE then the output will be returned to the console.
}
\examples{

# copy dummy package to tempdir
file.copy(system.file('pkg',package = 'sinew'),tempdir(),recursive = TRUE)

pkg_dir <- file.path(tempdir(),'pkg')
pkg_dir_R <- file.path(pkg_dir,'R')
pkg_dir_DESC <- file.path(pkg_dir,'DESCRIPTION')

# update namespaces in package functions
pretty_namespace(pkg_dir_R,overwrite = TRUE)

# send result to the console
update_desc(pkg_dir_R,overwrite = FALSE)

# overwrite the Imports field
update_desc(pkg_dir_R,overwrite = TRUE)

# view DESCRIPTION file
cat(readLines(pkg_dir_DESC),sep='\n')

# cleanup tempdir
unlink(pkg_dir,recursive = TRUE,force = TRUE)

}
\author{
Jonathan Sidi
}
\concept{populate}
