% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aria_desktop_build.R
\name{aria_desktop_build}
\alias{aria_desktop_build}
\title{Build ARIA desktop version}
\usage{
aria_desktop_build(aria_folder = "", download_dependencies = TRUE)
}
\arguments{
\item{aria_folder}{The folder you want to create the executable.}

\item{download_dependencies}{Download all the dependencies: r-portable and packages
needed to run the ARIA. Use FALSE if you already have the dependencies in the
aria_folder.}
}
\value{
Create the setup to build ARIA desktop in your specified folder.
}
\description{
Build the desktop version of ARIA automatically. You will need
\href{https://jrsoftware.org/isdl.php}{innosetup} to build the executable.
Only works in windows. See Details for more information.
}
\details{
To create the executable correctly, follow theses steps:
\itemize{
\item Build the sistec package (in Rstudio, you use ctrl + shift + b)
\item Create a folder
\item Use \code{aria_desktop_build("your folder")}
\item Install innosetup (if you don't have it installed yet)
\item Double click the .iss file created in your folder and run it.
}
}
\examples{
\dontrun{
aria_folder <- tempdir()
aria_desktop_build(aria_folder)
}
}
