% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_grid_systems.R
\name{sits_roi_to_mgrs}
\alias{sits_roi_to_mgrs}
\title{Given a ROI, find MGRS tiles intersecting it.}
\usage{
sits_roi_to_mgrs(roi)
}
\arguments{
\item{roi}{Valid ROI to use in other SITS functions}
}
\value{
tiles                Character vector with names of MGRS tiles
}
\description{
Takes a a ROI and produces a list of MGRS tiles intersecting it
}
\note{
To define a \code{roi} use one of:
     \itemize{
       \item{A path to a shapefile with polygons;}
       \item{A \code{sfc} or \code{sf} object from \code{sf} package;}
       \item{A \code{SpatExtent} object from \code{terra} package;}
       \item{A named \code{vector} (\code{"lon_min"},
            \code{"lat_min"}, \code{"lon_max"}, \code{"lat_max"}) in WGS84;}
       \item{A named \code{vector} (\code{"xmin"}, \code{"xmax"},
             \code{"ymin"}, \code{"ymax"}) with XY coordinates.}
      }

     Defining a region of interest using \code{SpatExtent} or XY values not
     in WGS84 requires the \code{crs} parameter to be specified.
}
\examples{
if (sits_run_examples()) {
# Defining a ROI
roi <- c(
  lon_min = -64.037,
  lat_min = -9.644,
  lon_max = -63.886,
  lat_max = -9.389
)
# Finding tiles
tiles <- sits_roi_to_mgrs(roi)
}
}
\author{
Felipe Carvalho, \email{felipe.carvalho@inpe.br}

Felipe Carlos, \email{efelipecarlos@gmail.com}
}
