% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_fam}
\alias{read_fam}
\title{Read PLINK-formatted .fam file}
\usage{
read_fam(file)
}
\arguments{
\item{file}{Input file path}
}
\value{
A tibble containing the 6 columns from the fam file.
}
\description{
Reads in a \href{https://www.cog-genomics.org/plink/1.9/formats#fam}{PLINK-formatted .fam file}. Input \code{file} must have six columns:
\enumerate{
\item Family ID
\item Individual ID
\item Father ID
\item Mother ID
\item Sex
\item Affected Status
}
}
\examples{
famfile <- system.file("extdata", "3gens.fam", package="skater", mustWork=TRUE)
fam <- read_fam(famfile)
fam

}
