% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical_cdf.R
\name{remp}
\alias{remp}
\title{Draws random values from the ECDF obtained from \code{sample}}
\usage{
remp(n, sample)
}
\arguments{
\item{n}{integer, number of samples to be drawn}

\item{sample}{numeric vector of sample values to base the ECDF on}
}
\value{
numeric vector of random values drawn from the ECDF
}
\description{
Based on the empirical cumulative density function as presented by
Chakraborti (2006).
}
\examples{
x <- 1:5
remp(10, x)
}
\references{
Chakraborti, S., Hong, B., & Van De Wiel, M. A. (2006).
A note on sample size determination for a nonparametric test of location.
Technometrics, 48(1), 88–94. https://doi.org/10.1198/004017005000000193
}
