% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slm-method.R
\name{vcov.slm}
\alias{vcov.slm}
\title{Calculate Variance-Covariance Matrix for a Fitted Model Object of class slm}
\usage{
\method{vcov}{slm}(object, ...)
}
\arguments{
\item{object}{a fitted model object of class slm.}

\item{...}{additional arguments for method functions.}
}
\value{
The variance-covariance matrix of the (non-normalized) least squares estimators for an object of class slm.
}
\description{
Returns the variance-covariance matrix of the (non-normalized) least squares estimators for an object of class slm.
}
\examples{
 n = 500
 eps = generative_process(n,"AR1",c(0.7))
 X = as.matrix(generative_model(n,"mod2"))
 Y = 3 + 2*X[,2] + eps
 reg = slm(Y ~ X, method_cov_st = "fitAR", model_selec = -1)
 vcov(reg)
}
\seealso{
The generic function \code{\link[stats:vcov]{vcov}}.

 The function \code{\link[slm:cov_matrix_estimator]{cov_matrix_estimator}}.
}
