% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss_sheet_share.R
\name{ss_sheet_share}
\alias{ss_sheet_share}
\title{Share a sheet with a user}
\usage{
ss_sheet_share(
  ss_id,
  email,
  access_level = c("VIEWER", "EDITOR", "COMMENTER", "EDITOR_SHARE", "OWNER", "ADMIN")
)
}
\arguments{
\item{ss_id}{The sheetId (or permalink) of the table}

\item{email}{The email address of the user to share to, i.e. a value in ss_list_users()$email}

\item{access_level}{A character object. See \url{https://smartsheet.redoc.ly/#section/Security/Access-Levels}}
}
\value{
An ss_resp object
}
\description{
Share a sheet with a user
}
\examples{
\dontrun{
ss_id = ss_sheetid(ss_write_sheet(paste0("smartsheetr-example-",random_sheet_name())))
users = ss_list_users()
user = users[1,'email']
ss_sheet_share(ss_id, user)
# clean up
ss_delete_sheet(ss_id)
}

}
