\name{snha-package} 
\alias{snha-package} 
\title{ snha package - association chain graphs from correlation networks} 
\description{The snha package can be used to construct association chain graphs  
   based on the St. Nicolas House Analysis (SNHA) algorithm as described in Groth et. al. 2019. 
   and Hermanussen et. al. 2021.} 
\details{The package provides the following functions: 
Function for graph generation from data: 
\describe{ 
\item{\link[snha:snha]{snha(data)}}{applys the SNHA method on the data and returns  
   a new snha graph object} 
} 
S3 methods for snha graphs: 
\describe{ 
\item{\link[snha:plot.snha]{plot.snha(x)}}{plots a snha graph} 
\item{\link[snha:as.list.snha]{as.list.snha(x)}}{return a list 
   representation of a snha graph object} 
} 
Utility functions: 
\describe{ 
\item{\link[snha:snha_get_chains]{snha_get_chains(g)}}{returns the chains found  
       by the algorithm as matrix} 
\item{\link[snha:snha_graph2data]{snha_graph2data(A)}}{create for the given 
       adjacency matrix some data with the appropiate correlations} 
\item{\link[snha:snha_layout]{snha_layout(g)}}{calculate layout coordinates  
       for the given graph or adjacency matrix} 
\item{\link[snha:snha_ll]{snha_ll(g,chain)}}{calculate log-likelihood for  
       the given chain of the snha graph} 
\item{\link[snha:snha_rsquare]{snha_rsquare(data,g)}}{for given data and graph  
        or adjacency matrix calculate linear model r-square value} 
} 
} 
\value{No return value}  
\examples{ 
library(MASS) 
data(birthwt) 
as=snha(birthwt[,-1]) 
plot(as) 
as$theta 
ls(as) 
data(decathlon88) 
head(decathlon88) 
dec=snha(decathlon88,method="spearman",alpha=0.1) 
plot(dec,layout='sam') 
} 
\author{Detlef Groth <dgroth@uni-potsdam.de>} 
\references{ 
\itemize{ 
   \item Groth, D., Scheffler, C., & Hermanussen, M. (2019).  
   Body height in stunted Indonesian children depends directly on parental education and not  
    via a nutrition mediated pathway -  
    Evidence from tracing association chains by St. Nicolas House Analysis.  
    \emph{Anthropologischer Anzeiger}, 76 No. 5 (2019), p. 445 - 451. 
    \doi{10.1127/anthranz/2019/1027} 
   \item Hermanussen, M., Assmann, & Groth, D. (2021). 
   Chain Reversion for Detecting Associations in Interacting Variables - St. Nicolas House Analysis. 
   \emph{International Journal of Environmental Research and Public Health}. 
   18, 4 (2021). \doi{10.3390/ijerph18041741}. 
   \item Novine, M., Mattsson, C. C., & Groth, D. (2021). 
   Network reconstruction based on synthetic data generated by a Monte Carlo 
   approach. \emph{Human Biology and Public Health}, 3:26. 
   \doi{10.52905/hbph2021.3.26} 
} 
} 
