% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-snic.R
\name{snic_class}
\alias{snic_class}
\alias{snic_get_means}
\alias{snic_get_centroids}
\alias{snic_get_seg}
\alias{snic_get_means.snic}
\alias{snic_get_centroids.snic}
\alias{snic_get_seg.snic}
\alias{print.snic}
\title{SNIC segmentation container}
\usage{
snic_get_means(x)

snic_get_centroids(x)

snic_get_seg(x)

\method{snic_get_means}{snic}(x)

\method{snic_get_centroids}{snic}(x)

\method{snic_get_seg}{snic}(x)

\method{print}{snic}(x, ...)
}
\arguments{
\item{x}{A \code{snic} object, typically the result of a call to
\code{\link{snic}}. It stores the segmentation map along with
per-cluster summaries (means, centroids, and metadata) produced
by the SNIC algorithm.}

\item{...}{Additional arguments passed to or from methods.
Currently unused, but included for compatibility with
S3 method dispatch.}
}
\value{
\itemize{
  \item \code{snic_get_means()}: Numeric matrix of per-cluster band means,
  or \code{NULL} when not available.
  \item \code{snic_get_centroids()}: Numeric matrix with columns
  \code{r} and \code{c} giving cluster centers in pixel coordinates
  (0-based), or \code{NULL} when not available.
  \item \code{snic_get_seg()}: Segmentation map in the native type of the
  input (\code{array} or \code{SpatRaster}) with integer labels and
  possible \code{NA} for unassigned pixels.
  \item \code{print.snic()}: Invisibly returns \code{x} after printing a
  human-readable summary.
}
}
\description{
Objects returned by \code{\link{snic}} inherit from the \code{snic}
S3 class. They are lightweight containers bundling the segmentation
result together with per-cluster summaries produced by the SNIC
algorithm. Internally, a \code{snic} object is a named list with
components:
\describe{
  \item{\code{seg}}{The segmentation map in the native type of the input
  (either a 3D integer \code{array} with dimensions
  \code{(height, width, 1)} or a single-layer
  \code{\link[terra:SpatRaster-class]{SpatRaster}}—matching the input
  given to \code{snic()}). Values are superpixel labels (positive integers);
  \code{NA} marks pixels that were not assigned.}
  \item{\code{means}}{Numeric matrix with one row per superpixel and one
  column per input band (column names preserved when available), giving the
  mean feature value of each cluster. May be \code{NULL} if the backend
  cannot retain these summaries.}
  \item{\code{centroids}}{Numeric matrix with columns \code{r} and \code{c}
  giving the cluster centers in pixel coordinates (0-based indices used by
  the SNIC core). May be \code{NULL} when centroids are unavailable.}
}
The list carries class \code{"snic"} to enable the accessors and print
methods below; the segmentation labels index the corresponding rows of
\code{means} and \code{centroids}.
}
\section{Accessors}{

\itemize{
  \item \code{\link{snic_get_seg}}: Retrieve the segmentation result.
  \item \code{\link{snic_get_means}}: Retrieve per-cluster feature means.
  \item \code{\link{snic_get_centroids}}: Retrieve per-cluster centroids.
}
}

\section{Methods}{

\itemize{
  \item \code{\link{snic_animation}}: Animate the segmentation process.
  \item \code{\link{print}}: Print a summary of the segmentation result.
  \item \code{\link{plot}}: Visualize the segmentation result.
}
}

