% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/social.cor.matrix.R
\name{social.cor.matrix}
\alias{social.cor.matrix}
\title{Social correlation matrix}
\usage{
social.cor.matrix(A, max.depth = nrow(A), n.pilot = 5000,
  n.estimate = 10000)
}
\arguments{
\item{A}{a (possibly weighted) adjacency matrix.}

\item{max.depth}{the maximum length of the paths to use.}

\item{n.pilot}{parameter to be passed to \code{\link{social.all.paths}}.}

\item{n.estimate}{parameter to be passed to \code{\link{social.all.paths}}.}
}
\value{
The calculated social correlation matrix.
}
\description{
Calculates the social correlation matrix for a given network
}
\examples{
A = matrix(c(0,1,0,1,0,
             1,0,0,1,1,
             0,0,0,1,1,
             1,1,1,0,0,
             0,1,1,0,0), nrow=5)
S = social.cor.matrix(A)

}
