% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmrs.R
\name{gen_conv_reg}
\alias{gen_conv_reg}
\title{Generate regressors by convolving a specified response function with a
stimulus.}
\usage{
gen_conv_reg(
  onset,
  duration = NULL,
  trial_type = NULL,
  mrs_data = NULL,
  tr = NULL,
  Ndyns = NULL,
  Ntrans = NULL,
  resp_fn,
  match_tr = TRUE,
  normalise = FALSE
)
}
\arguments{
\item{onset}{stimulus onset in seconds.}

\item{duration}{stimulus duration in seconds.}

\item{trial_type}{string label for the stimulus.}

\item{mrs_data}{mrs_data object for timing information.}

\item{tr}{repetition time.}

\item{Ndyns}{number of dynamic scans stored, potentially less than Ntrans
if block averaging has been performed.}

\item{Ntrans}{number of dynamic scans acquired.}

\item{resp_fn}{a data frame specifying the response function to be convolved.}

\item{match_tr}{match the output to the input mrs_data.}

\item{normalise}{normalise the response function to have a maximum value of
one.}
}
\value{
BOLD regressor data frame.
}
\description{
Generate regressors by convolving a specified response function with a
stimulus.
}
