% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_optimization.R
\name{plot_optimization}
\alias{plot_optimization}
\title{Optimization plot of a selection of spatial predictors}
\usage{
plot_optimization(
  model,
  point.color = viridis::viridis(
    100,
    option = "F",
    direction = -1
  ),
  verbose = TRUE
)
}
\arguments{
\item{model}{A model produced by \code{\link[=rf_spatial]{rf_spatial()}}, or an optimization data frame produced by \code{\link[=select_spatial_predictors_sequential]{select_spatial_predictors_sequential()}} or \code{\link[=select_spatial_predictors_recursive]{select_spatial_predictors_recursive()}}.}

\item{point.color}{Colors of the plotted points. Can be a single color name (e.g. "red4"), a character vector with hexadecimal codes (e.g. "#440154FF" "#21908CFF" "#FDE725FF"), or function generating a palette (e.g. \code{viridis::viridis(100)}). Default: \code{viridis::viridis(100, option = "F", direction = -1)}}

\item{verbose}{Logical, if \code{TRUE} the plot is printed. Default: \code{TRUE}}
}
\value{
A ggplot.
}
\description{
Plots optimization data frames produced by \code{\link[=select_spatial_predictors_sequential]{select_spatial_predictors_sequential()}}
and \code{\link[=select_spatial_predictors_recursive]{select_spatial_predictors_recursive()}}.
}
\details{
If the method used to fit a model with \code{\link[=rf_spatial]{rf_spatial()}} is "hengl", the function returns nothing, as this method does not require optimization.
}
\examples{
if(interactive()){

 #loading example data
 data(distance_matrix)
 data(plant_richness_df)

 #names of the response and predictors
 dependent.variable.name <- "richness_species_vascular"
 predictor.variable.names <- colnames(plant_richness_df)[5:21]

 #spatial model
 model <- rf_spatial(
   data = plant_richness_df,
   dependent.variable.name = dependent.variable.name,
   predictor.variable.names = predictor.variable.names,
   distance.matrix = distance_matrix,
   distance.thresholds = 0,
   method = "mem.moran.sequential",
   n.cores = 1,
   seed = 1
 )

 #plotting selection of spatial predictors
 plot_optimization(model = model)


}
}
