% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vif.R
\name{vif}
\alias{vif}
\title{Variance Inflation Factor of a data frame}
\usage{
vif(x)
}
\arguments{
\item{x}{Data frame with numeric columns, typically containing a set of model predictors.}
}
\value{
A data frame with two columns having the name of the variables in 'x' and their respective VIF values.
}
\description{
Computes the variance inflation factor (VIF) of the colums in a data frame. \strong{Warning}: variables in \code{preference.order} not in \code{colnames(x)}, and non-numeric columns are removed silently from \code{x} and \code{preference.order}. The same happens with rows having NA values (\code{\link[=na.omit]{na.omit()}} is applied). The function issues a warning if zero-variance columns are found.
}
\examples{
if(interactive()){

 data(plant_richness_df)

 vif(plant_richness_df[, 5:21])

}
}
\seealso{
\code{\link[=auto_vif]{auto_vif()}}, \code{\link[=auto_cor]{auto_cor()}}
}
