% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{.onAttach}
\alias{.onAttach}
\title{Setting up multithread BLAS library}
\usage{
.onAttach(libname, pkgname)
}
\arguments{
\item{libname}{a character string giving the library directory where the package defining the namespace was found.}

\item{pkgname}{a character string giving the name of the package.}
}
\description{
The number of used cores is set to \code{RhpcBLASctl::get_num_cores()} on the
attach event of the package.
}
\details{
The algebra system of R relies on a BLAS library
which can be set to use many threads / cores. This
feature is considered as experimental since there are many differences across
the operating systems R is running on. If there is an issue and there is a need
to run R in multi-thread mode, consider to install
a different optimized version of BLAS.
If necessary, the number of cores required can also be changed manually
by calling \code{blas_set_num_threads(nCores)} and
\code{omp_set_num_threads(nCores)}.


This function is invoked automatically
}
