% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CLASS_seq_anova_results.R
\docType{class}
\name{seq_anova_results-class}
\alias{seq_anova_results-class}
\title{An S4 class to represent the results of a sequential anova.}
\arguments{
\item{plot}{list with all arguments for the plot_anova() function}
}
\description{
An S4 class to represent the results of a sequential anova.
}
\section{Slots}{

\describe{
\item{\code{likelihood_ratio_log}}{the logarithmic test statistic.}

\item{\code{decision}}{the test decision: "accept H1", "accept H0",
or "continue sampling".}

\item{\code{A_boundary_log}}{the lower logarithmic boundary of the test.}

\item{\code{B_boundary_log}}{the upper logarithmic boundary of the test.}

\item{\code{f}}{a number indicating the specified effect size (Cohen's f).}

\item{\code{effect_sizes}}{a list with effect sizes (Cohen's f, eta squared, ...).}

\item{\code{alpha}}{the type I error. A number between 0 and 1.}

\item{\code{power}}{1 - beta (beta is the type II error probability). A number
between 0 and 1.}

\item{\code{likelihood_ratio}}{the likelihood ratio of the test without logarithm.}

\item{\code{likelihood_1}}{the likelihood of the alternative Hypothesis (H1).}

\item{\code{likelihood_0}}{the likelihood of the null Hypothesis (H0).}

\item{\code{likelihood_1_log}}{the logarithmic likelihood of the alternative
Hypothesis (H1).}

\item{\code{likelihood_0_log}}{the logarithmic likelihood of the null
Hypothesis (H0).}

\item{\code{non_centrality_parameter}}{parameter to calculate the likelihoods}

\item{\code{F_value}}{the F-value of the F-statistic.}

\item{\code{df_1}}{degrees of freedom.}

\item{\code{df_2}}{degrees of freedom.}

\item{\code{ss_effect}}{ss_effect.}

\item{\code{ss_residual}}{ss_residual.}

\item{\code{ss_total}}{ss_total.}

\item{\code{total_sample_size}}{total sample size.}

\item{\code{data_name}}{a character string giving the name(s) of the data.}

\item{\code{verbose}}{a logical value whether you want a verbose output or not.}
}}

\keyword{internal}
