% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sprtt.R
\docType{package}
\name{sprtt-package}
\alias{sprtt}
\alias{sprtt-package}
\title{sprtt: Sequential Probability Ratio Tests Toolbox}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

It is a toolbox for Sequential Probability Ratio Tests (SPRT), Wald (1945) \doi{10.2134/agronj1947.00021962003900070011x}. SPRTs are applied to the data during the sampling process, ideally after each observation. At any stage, the test will return a decision to either continue sampling or terminate and accept one of the specified hypotheses. The seq_ttest() function performs one-sample, two-sample, and paired t-tests for testing one- and two-sided hypotheses (Schnuerch & Erdfelder (2019) \doi{10.1037/met0000234}). The seq_anova() function allows to perform a sequential one-way fixed effects ANOVA (Steinhilber et al. (2023) \doi{10.31234/osf.io/m64ne}). Learn more about the package by using vignettes "browseVignettes(package = "sprtt")" or go to the website \url{https://meikesteinhilber.github.io/sprtt/}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://meikesteinhilber.github.io/sprtt/}
  \item Report bugs at \url{https://github.com/MeikeSteinhilber/sprtt/issues}
}

}
\author{
\strong{Maintainer}: Meike Steinhilber \email{Meike.Steinhilber@aol.com} (\href{https://orcid.org/0000-0002-7144-2100}{ORCID})

Authors:
\itemize{
  \item Martin Schnuerch (\href{https://orcid.org/0000-0001-6531-2265}{ORCID}) [thesis advisor]
  \item Anna-Lena Schubert (\href{https://orcid.org/0000-0001-7248-0662}{ORCID}) [thesis advisor]
}

}
\keyword{internal}
