# draw_sample_normal: check correct behaviour

    Code
      show(draw_sample_normal(k_groups = 2, f = 0.25, max_n = 30))
    Output
                   y x
      1  -2.30128979 1
      2   0.52773897 2
      3  -1.77596060 1
      4  -0.01916362 2
      5   0.98305388 1
      6   0.88360774 2
      7   0.10271746 1
      8  -0.31048248 2
      9  -1.37490028 1
      10 -0.62430362 2
      11 -0.20613838 1
      12 -0.33397514 2
      13 -1.07329858 1
      14  0.36059280 2
      15  0.11472778 1
      16  0.30370100 2
      17  1.11867235 1
      18 -0.13045724 2
      19 -0.95632036 1
      20  1.21687656 2
      21 -0.96016648 1
      22  0.19082635 2
      23 -0.48094342 1
      24  0.94200045 2
      25  1.10682290 1
      26  2.03872284 2
      27  0.16071582 1
      28 -1.93785470 2
      29 -0.95278946 1
      30  0.54986416 2
      31  0.89946968 1
      32 -0.05164149 2
      33 -0.79733935 1
      34 -0.13540415 2
      35  0.02637203 1
      36  0.40186081 2
      37 -0.68138079 1
      38 -1.62050006 2
      39 -0.17366674 1
      40  0.01964405 2
      41  0.06746484 1
      42 -1.34268440 2
      43 -0.43194062 1
      44  2.00614174 2
      45 -0.13605068 1
      46 -0.04216508 2
      47  1.50409316 1
      48  2.05958455 2
      49 -0.41706889 1
      50  1.49128597 2
      51  0.04010419 1
      52  0.19627645 2
      53 -0.17569522 1
      54  0.13560610 2
      55 -1.68381629 1
      56 -0.09207492 2
      57  0.18550459 1
      58  0.54297294 2
      59 -1.10981789 1
      60  1.30689333 2

---

    Code
      show(draw_sample_normal(k_groups = 4, f = 1, sd = c(1, 0.8, 1, 1), max_n = 30))
    Output
                    y x
      1   -0.97359684 1
      2    1.14097958 2
      3   -1.12270522 3
      4   -2.65066851 4
      5    0.25476947 1
      6   -0.47805947 2
      7   -0.27788822 3
      8   -1.28471300 4
      9    0.28386638 1
      10  -0.34597016 2
      11  -0.14637930 3
      12   0.12857747 4
      13   1.87775659 1
      14   0.25154051 2
      15   0.96273137 3
      16  -0.59832287 4
      17  -0.17971706 1
      18  -1.18839393 2
      19   0.12479108 3
      20  -1.28483404 4
      21   1.17213816 1
      22   0.37554315 2
      23   0.63468484 3
      24  -2.85283746 4
      25   1.96726846 1
      26   0.18740073 2
      27   1.48936086 3
      28  -0.03880732 4
      29   0.60829762 1
      30  -0.07302225 2
      31   0.89495215 3
      32  -3.33728160 4
      33   0.98816642 1
      34   0.26442197 2
      35   0.38757643 3
      36  -1.00285665 4
      37   0.36527269 1
      38   1.66521636 2
      39   0.45412581 3
      40  -2.80828333 4
      41  -0.24377594 1
      42  -0.26936384 2
      43   0.01259100 3
      44  -1.35897923 4
      45   0.99194620 1
      46  -0.25056638 2
      47   0.43321193 3
      48  -1.89438506 4
      49   3.11603445 1
      50   0.34404012 2
      51   0.70812658 3
      52  -1.25336223 4
      53   1.66344305 1
      54   0.34051343 2
      55   0.69780345 3
      56  -1.04893182 4
      57  -0.21474052 1
      58  -0.89835710 2
      59   2.50661451 3
      60  -0.03909643 4
      61   0.97213776 1
      62   0.58175123 2
      63   1.02602495 3
      64  -1.23554496 4
      65   0.36100896 1
      66  -1.51871162 2
      67   0.01726798 3
      68  -1.36800653 4
      69  -1.43527725 1
      70   0.54598193 2
      71   0.79224568 3
      72  -0.85135106 4
      73   1.68370015 1
      74   1.92938614 2
      75   0.62847109 3
      76  -0.63367871 4
      77   0.84330208 1
      78   1.24457511 2
      79   1.37429627 3
      80  -0.40494692 4
      81   2.76131930 1
      82   0.34880539 2
      83   1.00058930 3
      84  -1.65217161 4
      85   2.15362714 1
      86   0.16936481 2
      87   1.17353474 3
      88  -0.87120355 4
      89   0.32375713 1
      90  -1.71353075 2
      91   0.72294907 3
      92  -0.31328298 4
      93   0.95824196 1
      94   0.42493943 2
      95   2.01132178 3
      96  -2.02363888 4
      97   1.72361329 1
      98   0.91187823 2
      99   2.05794008 3
      100 -2.41948073 4
      101 -0.82616035 1
      102 -1.06990486 2
      103  0.74828918 3
      104 -2.36455247 4
      105  0.90625077 1
      106  0.97124913 2
      107 -0.73473633 3
      108 -0.80467140 4
      109  1.90673699 1
      110 -0.11019307 2
      111  0.86674084 3
      112 -2.07180330 4
      113  1.17725606 1
      114 -1.18412428 2
      115 -0.19673848 3
      116 -1.53364871 4
      117  1.94964353 1
      118 -0.58430960 2
      119  1.17936536 3
      120 -2.42016539 4

---

    Code
      show(draw_sample_normal(k_groups = 3, f = 0.12, sd = c(1, 0.8, 2),
      sample_ratio = c(1, 2, 1), max_n = 50))
    Output
                     y x
      1   -0.936675605 1
      2   -0.226495718 2
      3    0.726903769 2
      4    1.171692758 3
      5    0.625765104 1
      6    0.121431936 2
      7    1.404898561 2
      8   -0.463956453 3
      9    1.276218694 1
      10   0.988857660 2
      11   0.825425744 2
      12  -1.961664564 3
      13  -0.081434902 1
      14  -0.267999180 2
      15   1.157428335 2
      16   0.297846188 3
      17   0.787176518 1
      18   1.087855584 2
      19  -0.057334887 2
      20  -1.364703384 3
      21  -1.044534741 1
      22  -0.959843244 2
      23  -0.969902906 2
      24  -2.047922860 3
      25   0.084171288 1
      26  -0.746268160 2
      27  -0.443365144 2
      28   2.764267254 3
      29   0.092174640 1
      30  -0.218944123 2
      31  -1.733187229 2
      32   0.260986113 3
      33   0.959491494 1
      34  -0.069193351 2
      35   0.568621828 2
      36   2.505688662 3
      37   0.375506716 1
      38  -1.568810495 2
      39  -0.598254780 2
      40   0.099080638 3
      41  -1.065773027 1
      42  -0.292174697 2
      43  -0.207858899 2
      44  -2.863657636 3
      45  -0.627534874 1
      46   2.454584668 2
      47   0.649545043 2
      48  -1.098047776 3
      49  -0.724620437 1
      50   0.480632479 2
      51   0.162462675 2
      52  -2.117389076 3
      53   0.421297252 1
      54  -0.425199435 2
      55  -0.318059197 2
      56   3.767242568 3
      57  -0.453672377 1
      58   0.340127844 2
      59  -0.827336962 2
      60   0.761081283 3
      61   0.119063619 1
      62   1.112774892 2
      63  -0.319780639 2
      64   0.434381525 3
      65   2.616104139 1
      66   0.379077942 2
      67   0.087260993 2
      68   0.460536143 3
      69   2.062928682 1
      70   0.562703989 2
      71   0.540852782 2
      72   2.669300377 3
      73  -1.126187466 1
      74   0.969438006 2
      75  -0.110448409 2
      76   0.200412295 3
      77   0.114899017 1
      78   0.562903113 2
      79  -0.874938428 2
      80   2.046722310 3
      81  -0.347652027 1
      82   0.513399111 2
      83  -0.197021579 2
      84   0.048880196 3
      85  -1.272650790 1
      86  -0.364024249 2
      87  -0.005338713 2
      88   1.998387388 3
      89   1.181871832 1
      90   0.488059301 2
      91  -0.183331245 2
      92  -1.847133816 3
      93  -0.080187948 1
      94   0.809648448 2
      95   1.170627104 2
      96   0.020854272 3
      97  -0.047562050 1
      98  -0.370831261 2
      99   0.089182715 2
      100  2.206326026 3
      101 -0.296804761 1
      102  0.728464307 2
      103  0.409324443 2
      104  0.647724512 3
      105 -0.045722368 1
      106  0.855722638 2
      107 -0.833750018 2
      108  1.187849650 3
      109 -0.126708788 1
      110  0.998049281 2
      111  0.553959313 2
      112 -4.111397098 3
      113  1.125439349 1
      114  1.036634448 2
      115  1.106736619 2
      116  6.652641665 3
      117  0.978951302 1
      118  1.519591769 2
      119  0.421018431 2
      120 -2.953812403 3
      121  1.228523122 1
      122 -0.007738038 2
      123  0.183137700 2
      124  2.186830430 3
      125 -0.650401364 1
      126  2.324544685 2
      127  0.818396901 2
      128  0.020695568 3
      129  0.006014754 1
      130  1.017913718 2
      131 -0.910423156 2
      132 -1.099665932 3
      133  2.308601113 1
      134 -0.841518372 2
      135  0.750021447 2
      136  0.775404325 3
      137 -0.653104908 1
      138  0.012648806 2
      139 -0.273025517 2
      140 -2.495480813 3
      141 -0.160619201 1
      142 -0.681265771 2
      143  0.568567683 2
      144 -2.547826677 3
      145  0.387336230 1
      146  0.146981391 2
      147  1.211387438 2
      148  1.588344020 3
      149  0.329922193 1
      150  1.142682795 2
      151 -0.296327036 2
      152 -1.995666362 3
      153 -0.262441660 1
      154 -0.084823594 2
      155  0.355180821 2
      156 -0.569200135 3
      157  0.368716253 1
      158  0.520577365 2
      159  0.870166136 2
      160  4.596592376 3
      161  0.673656960 1
      162  0.206732023 2
      163  1.328961216 2
      164  1.397614675 3
      165 -0.458671107 1
      166  0.776654055 2
      167 -0.640149732 2
      168 -1.305364301 3
      169  0.460997688 1
      170 -0.649177226 2
      171  0.731561855 2
      172  3.011606470 3
      173  0.739496915 1
      174  1.078734838 2
      175 -0.244194955 2
      176  1.059978916 3
      177 -1.606052747 1
      178  0.855640045 2
      179  0.168354194 2
      180  1.895596565 3
      181  1.742529269 1
      182  1.020426598 2
      183  0.320661005 2
      184  0.079637765 3
      185 -0.970342883 1
      186  0.844350589 2
      187 -1.667785773 2
      188  0.763828592 3
      189  1.644208206 1
      190  0.056109208 2
      191  0.099161837 2
      192  4.629369369 3
      193  1.113327804 1
      194 -0.393152388 2
      195  0.609521646 2
      196  0.409718664 3
      197 -1.427810492 1
      198  0.567318876 2
      199 -0.083888348 2
      200 -1.498606763 3

---

    Code
      show(draw_sample_normal(k_groups = 2, f = 0.25, max_n = 30))
    Output
                   y x
      1  -2.30128979 1
      2   0.52773897 2
      3  -1.77596060 1
      4  -0.01916362 2
      5   0.98305388 1
      6   0.88360774 2
      7   0.10271746 1
      8  -0.31048248 2
      9  -1.37490028 1
      10 -0.62430362 2
      11 -0.20613838 1
      12 -0.33397514 2
      13 -1.07329858 1
      14  0.36059280 2
      15  0.11472778 1
      16  0.30370100 2
      17  1.11867235 1
      18 -0.13045724 2
      19 -0.95632036 1
      20  1.21687656 2
      21 -0.96016648 1
      22  0.19082635 2
      23 -0.48094342 1
      24  0.94200045 2
      25  1.10682290 1
      26  2.03872284 2
      27  0.16071582 1
      28 -1.93785470 2
      29 -0.95278946 1
      30  0.54986416 2
      31  0.89946968 1
      32 -0.05164149 2
      33 -0.79733935 1
      34 -0.13540415 2
      35  0.02637203 1
      36  0.40186081 2
      37 -0.68138079 1
      38 -1.62050006 2
      39 -0.17366674 1
      40  0.01964405 2
      41  0.06746484 1
      42 -1.34268440 2
      43 -0.43194062 1
      44  2.00614174 2
      45 -0.13605068 1
      46 -0.04216508 2
      47  1.50409316 1
      48  2.05958455 2
      49 -0.41706889 1
      50  1.49128597 2
      51  0.04010419 1
      52  0.19627645 2
      53 -0.17569522 1
      54  0.13560610 2
      55 -1.68381629 1
      56 -0.09207492 2
      57  0.18550459 1
      58  0.54297294 2
      59 -1.10981789 1
      60  1.30689333 2

---

    Code
      show(draw_sample_normal(k_groups = 4, f = 1, sd = c(1, 0.8, 1, 1), max_n = 30))
    Output
                    y x
      1   -0.97359684 1
      2    1.14097958 2
      3   -1.12270522 3
      4   -2.65066851 4
      5    0.25476947 1
      6   -0.47805947 2
      7   -0.27788822 3
      8   -1.28471300 4
      9    0.28386638 1
      10  -0.34597016 2
      11  -0.14637930 3
      12   0.12857747 4
      13   1.87775659 1
      14   0.25154051 2
      15   0.96273137 3
      16  -0.59832287 4
      17  -0.17971706 1
      18  -1.18839393 2
      19   0.12479108 3
      20  -1.28483404 4
      21   1.17213816 1
      22   0.37554315 2
      23   0.63468484 3
      24  -2.85283746 4
      25   1.96726846 1
      26   0.18740073 2
      27   1.48936086 3
      28  -0.03880732 4
      29   0.60829762 1
      30  -0.07302225 2
      31   0.89495215 3
      32  -3.33728160 4
      33   0.98816642 1
      34   0.26442197 2
      35   0.38757643 3
      36  -1.00285665 4
      37   0.36527269 1
      38   1.66521636 2
      39   0.45412581 3
      40  -2.80828333 4
      41  -0.24377594 1
      42  -0.26936384 2
      43   0.01259100 3
      44  -1.35897923 4
      45   0.99194620 1
      46  -0.25056638 2
      47   0.43321193 3
      48  -1.89438506 4
      49   3.11603445 1
      50   0.34404012 2
      51   0.70812658 3
      52  -1.25336223 4
      53   1.66344305 1
      54   0.34051343 2
      55   0.69780345 3
      56  -1.04893182 4
      57  -0.21474052 1
      58  -0.89835710 2
      59   2.50661451 3
      60  -0.03909643 4
      61   0.97213776 1
      62   0.58175123 2
      63   1.02602495 3
      64  -1.23554496 4
      65   0.36100896 1
      66  -1.51871162 2
      67   0.01726798 3
      68  -1.36800653 4
      69  -1.43527725 1
      70   0.54598193 2
      71   0.79224568 3
      72  -0.85135106 4
      73   1.68370015 1
      74   1.92938614 2
      75   0.62847109 3
      76  -0.63367871 4
      77   0.84330208 1
      78   1.24457511 2
      79   1.37429627 3
      80  -0.40494692 4
      81   2.76131930 1
      82   0.34880539 2
      83   1.00058930 3
      84  -1.65217161 4
      85   2.15362714 1
      86   0.16936481 2
      87   1.17353474 3
      88  -0.87120355 4
      89   0.32375713 1
      90  -1.71353075 2
      91   0.72294907 3
      92  -0.31328298 4
      93   0.95824196 1
      94   0.42493943 2
      95   2.01132178 3
      96  -2.02363888 4
      97   1.72361329 1
      98   0.91187823 2
      99   2.05794008 3
      100 -2.41948073 4
      101 -0.82616035 1
      102 -1.06990486 2
      103  0.74828918 3
      104 -2.36455247 4
      105  0.90625077 1
      106  0.97124913 2
      107 -0.73473633 3
      108 -0.80467140 4
      109  1.90673699 1
      110 -0.11019307 2
      111  0.86674084 3
      112 -2.07180330 4
      113  1.17725606 1
      114 -1.18412428 2
      115 -0.19673848 3
      116 -1.53364871 4
      117  1.94964353 1
      118 -0.58430960 2
      119  1.17936536 3
      120 -2.42016539 4

---

    Code
      show(draw_sample_normal(k_groups = 3, f = 0.12, sd = c(1, 0.8, 2),
      sample_ratio = c(1, 2, 1), max_n = 50))
    Output
                     y x
      1   -0.936675605 1
      2   -0.226495718 2
      3    0.726903769 2
      4    1.171692758 3
      5    0.625765104 1
      6    0.121431936 2
      7    1.404898561 2
      8   -0.463956453 3
      9    1.276218694 1
      10   0.988857660 2
      11   0.825425744 2
      12  -1.961664564 3
      13  -0.081434902 1
      14  -0.267999180 2
      15   1.157428335 2
      16   0.297846188 3
      17   0.787176518 1
      18   1.087855584 2
      19  -0.057334887 2
      20  -1.364703384 3
      21  -1.044534741 1
      22  -0.959843244 2
      23  -0.969902906 2
      24  -2.047922860 3
      25   0.084171288 1
      26  -0.746268160 2
      27  -0.443365144 2
      28   2.764267254 3
      29   0.092174640 1
      30  -0.218944123 2
      31  -1.733187229 2
      32   0.260986113 3
      33   0.959491494 1
      34  -0.069193351 2
      35   0.568621828 2
      36   2.505688662 3
      37   0.375506716 1
      38  -1.568810495 2
      39  -0.598254780 2
      40   0.099080638 3
      41  -1.065773027 1
      42  -0.292174697 2
      43  -0.207858899 2
      44  -2.863657636 3
      45  -0.627534874 1
      46   2.454584668 2
      47   0.649545043 2
      48  -1.098047776 3
      49  -0.724620437 1
      50   0.480632479 2
      51   0.162462675 2
      52  -2.117389076 3
      53   0.421297252 1
      54  -0.425199435 2
      55  -0.318059197 2
      56   3.767242568 3
      57  -0.453672377 1
      58   0.340127844 2
      59  -0.827336962 2
      60   0.761081283 3
      61   0.119063619 1
      62   1.112774892 2
      63  -0.319780639 2
      64   0.434381525 3
      65   2.616104139 1
      66   0.379077942 2
      67   0.087260993 2
      68   0.460536143 3
      69   2.062928682 1
      70   0.562703989 2
      71   0.540852782 2
      72   2.669300377 3
      73  -1.126187466 1
      74   0.969438006 2
      75  -0.110448409 2
      76   0.200412295 3
      77   0.114899017 1
      78   0.562903113 2
      79  -0.874938428 2
      80   2.046722310 3
      81  -0.347652027 1
      82   0.513399111 2
      83  -0.197021579 2
      84   0.048880196 3
      85  -1.272650790 1
      86  -0.364024249 2
      87  -0.005338713 2
      88   1.998387388 3
      89   1.181871832 1
      90   0.488059301 2
      91  -0.183331245 2
      92  -1.847133816 3
      93  -0.080187948 1
      94   0.809648448 2
      95   1.170627104 2
      96   0.020854272 3
      97  -0.047562050 1
      98  -0.370831261 2
      99   0.089182715 2
      100  2.206326026 3
      101 -0.296804761 1
      102  0.728464307 2
      103  0.409324443 2
      104  0.647724512 3
      105 -0.045722368 1
      106  0.855722638 2
      107 -0.833750018 2
      108  1.187849650 3
      109 -0.126708788 1
      110  0.998049281 2
      111  0.553959313 2
      112 -4.111397098 3
      113  1.125439349 1
      114  1.036634448 2
      115  1.106736619 2
      116  6.652641665 3
      117  0.978951302 1
      118  1.519591769 2
      119  0.421018431 2
      120 -2.953812403 3
      121  1.228523122 1
      122 -0.007738038 2
      123  0.183137700 2
      124  2.186830430 3
      125 -0.650401364 1
      126  2.324544685 2
      127  0.818396901 2
      128  0.020695568 3
      129  0.006014754 1
      130  1.017913718 2
      131 -0.910423156 2
      132 -1.099665932 3
      133  2.308601113 1
      134 -0.841518372 2
      135  0.750021447 2
      136  0.775404325 3
      137 -0.653104908 1
      138  0.012648806 2
      139 -0.273025517 2
      140 -2.495480813 3
      141 -0.160619201 1
      142 -0.681265771 2
      143  0.568567683 2
      144 -2.547826677 3
      145  0.387336230 1
      146  0.146981391 2
      147  1.211387438 2
      148  1.588344020 3
      149  0.329922193 1
      150  1.142682795 2
      151 -0.296327036 2
      152 -1.995666362 3
      153 -0.262441660 1
      154 -0.084823594 2
      155  0.355180821 2
      156 -0.569200135 3
      157  0.368716253 1
      158  0.520577365 2
      159  0.870166136 2
      160  4.596592376 3
      161  0.673656960 1
      162  0.206732023 2
      163  1.328961216 2
      164  1.397614675 3
      165 -0.458671107 1
      166  0.776654055 2
      167 -0.640149732 2
      168 -1.305364301 3
      169  0.460997688 1
      170 -0.649177226 2
      171  0.731561855 2
      172  3.011606470 3
      173  0.739496915 1
      174  1.078734838 2
      175 -0.244194955 2
      176  1.059978916 3
      177 -1.606052747 1
      178  0.855640045 2
      179  0.168354194 2
      180  1.895596565 3
      181  1.742529269 1
      182  1.020426598 2
      183  0.320661005 2
      184  0.079637765 3
      185 -0.970342883 1
      186  0.844350589 2
      187 -1.667785773 2
      188  0.763828592 3
      189  1.644208206 1
      190  0.056109208 2
      191  0.099161837 2
      192  4.629369369 3
      193  1.113327804 1
      194 -0.393152388 2
      195  0.609521646 2
      196  0.409718664 3
      197 -1.427810492 1
      198  0.567318876 2
      199 -0.083888348 2
      200 -1.498606763 3

---

    Code
      show(draw_sample_mixture(k_groups = 2, f = 0.25, max_n = 30))
    Output
                     y x
      1  -0.2968702606 1
      2   0.6607203106 2
      3   1.4095880545 1
      4  -0.2448679336 2
      5  -0.6702344560 1
      6   0.0501637476 2
      7  -0.4452344660 1
      8   0.6138762655 2
      9  -0.5893696450 1
      10  0.7303497113 2
      11 -0.2416966848 1
      12  1.7096232457 2
      13 -0.7096275313 1
      14  0.1768280627 2
      15 -1.0189153142 1
      16  2.7613021658 2
      17  1.9641215394 1
      18 -0.4269716436 2
      19 -0.7524266134 1
      20 -0.1272248880 2
      21 -0.1493983361 1
      22  0.8260163228 2
      23 -1.7704069078 1
      24 -1.9212372322 2
      25 -0.6461265922 1
      26  0.8786009089 2
      27  0.0006366895 1
      28  2.7196096271 2
      29  0.1150761453 1
      30  0.9282329414 2
      31 -0.7716141899 1
      32  0.6649468400 2
      33 -1.6054518644 1
      34  0.0657939115 2
      35  0.4546699052 1
      36 -0.1479842666 2
      37  0.8698142164 1
      38 -0.4138045066 2
      39 -1.7788454825 1
      40  0.1029840996 2
      41 -0.2011453577 1
      42 -2.0765600978 2
      43  1.2032955163 1
      44 -0.5536740605 2
      45 -0.5709375100 1
      46 -0.5789744183 2
      47 -1.1251355097 1
      48 -0.0113962633 2
      49 -0.0135605340 1
      50  0.4689167592 2
      51  0.6118623673 1
      52  0.5000437756 2
      53  0.5140284097 1
      54 -0.1874250390 2
      55  1.2229549556 1
      56  1.1427130337 2
      57 -0.1737896621 1
      58  0.5148740548 2
      59 -2.7390686206 1
      60  2.3657533523 2

---

    Code
      show(draw_sample_mixture(k_groups = 4, f = 1, max_n = 30, verbose = TRUE))
    Message <simpleMessage>
      Internal counter reached = 20
    Output
      
      group1:
      mean1 = 2.39757189786258, mean2 = 0.477274458301153,
      sigma1 = 0.358633853981776, sigma2 = 0.166164468479555
      
      group2:
      mean1 = 0.736981515751464, mean2 = 0.126439598953774,
      sigma1 = 1.25288307963288, sigma2 = 0.493865642342263
      
      group3:
      mean1 = -1.67319856386094, mean2 = -0.161002627615745,
      sigma1 = 0.849040039667253, sigma2 = 0.368459952021357
      
      group4:
      mean1 = -1.75265800055532, mean2 = -0.15140827883696,
      sigma1 = 0.81033877122771, sigma2 = 0.247690815723145
                    y x
      1    2.49104456 1
      2    0.06753235 2
      3   -0.46837304 3
      4   -0.91873555 4
      5    0.31890644 1
      6    0.77947668 2
      7   -1.67306561 3
      8   -2.56985649 4
      9    2.97617570 1
      10  -0.04715433 2
      11   0.30601694 3
      12  -2.20476455 4
      13   2.35447149 1
      14  -0.11040413 2
      15   0.03610313 3
      16  -1.79930793 4
      17   0.64823280 1
      18  -0.26477413 2
      19  -0.05222434 3
      20  -0.24653651 4
      21   2.15165347 1
      22   0.34867586 2
      23  -0.09887635 3
      24  -2.28778350 4
      25   2.79090221 1
      26   1.00409701 2
      27  -0.62186552 3
      28  -0.02457762 4
      29   1.86234961 1
      30   2.49615829 2
      31  -0.10474259 3
      32  -0.25016441 4
      33   2.57195759 1
      34   0.34521325 2
      35  -0.87974593 3
      36  -1.97796463 4
      37   2.66507840 1
      38   0.17281003 2
      39  -0.71230732 3
      40  -1.96927789 4
      41   2.99515416 1
      42   0.29900976 2
      43   0.03693386 3
      44  -0.15402785 4
      45   2.73981076 1
      46   0.16588951 2
      47  -0.22921627 3
      48  -0.18835592 4
      49   2.20938191 1
      50   1.55127234 2
      51  -1.45584980 3
      52  -0.14549104 4
      53   2.81971774 1
      54   0.45405897 2
      55   0.21312599 3
      56  -0.04445480 4
      57   0.49242503 1
      58   0.63766279 2
      59  -1.45549759 3
      60   0.10831122 4
      61   2.58954010 1
      62  -0.56865332 2
      63  -3.00665123 3
      64  -0.15926618 4
      65   3.12749177 1
      66   1.43273106 2
      67  -1.35236819 3
      68  -0.13267623 4
      69   2.94552192 1
      70   0.13512123 2
      71  -1.45182938 3
      72  -1.20415586 4
      73   2.18533656 1
      74   0.43023093 2
      75  -0.34791696 3
      76  -0.17394993 4
      77   0.51774342 1
      78  -0.46840212 2
      79  -3.43035286 3
      80   0.15909384 4
      81   1.71652658 1
      82   0.70312983 2
      83  -0.13079071 3
      84  -0.19917042 4
      85   0.27962495 1
      86   0.46742704 2
      87  -0.99337467 3
      88   0.05344711 4
      89   2.21816715 1
      90   0.12533742 2
      91  -1.45208827 3
      92  -2.06792769 4
      93   2.38521358 1
      94  -0.16159738 2
      95  -1.78133764 3
      96   0.01053335 4
      97   2.82372521 1
      98   2.09983237 2
      99  -0.05350457 3
      100 -2.99769552 4
      101  2.37837676 1
      102  2.01147808 2
      103 -1.89890427 3
      104 -0.11668711 4
      105  2.57138931 1
      106  1.73276229 2
      107 -0.29999702 3
      108 -0.36388305 4
      109  0.70907513 1
      110  1.30388315 2
      111 -1.23450346 3
      112 -1.34647141 4
      113  1.97244184 1
      114  0.34793924 2
      115 -0.56975202 3
      116  0.02053626 4
      117  0.52204453 1
      118  0.06589181 2
      119 -0.12243416 3
      120 -2.12636799 4

---

    Code
      show(draw_sample_mixture(k_groups = 3, f = 0.12, max_n = 50, verbose = TRUE))
    Message <simpleMessage>
      Internal counter reached = 1
    Output
      
      group1:
      mean1 = 0.0867802101979348, mean2 = 0.00955713831518447,
      sigma1 = 1.30563697775076, sigma2 = 0.540675855679126
      
      group2:
      mean1 = -0.279915446859539, mean2 = -0.0501030747645439,
      sigma1 = 1.28631183855406, sigma2 = 0.564796415367255
      
      group3:
      mean1 = 0.210848011345869, mean2 = 0.0228331617650952,
      sigma1 = 1.26519083500062, sigma2 = 0.617751858919898
                     y x
      1   -0.241095536 1
      2   -0.193427700 2
      3   -0.275724253 3
      4   -0.696909824 1
      5   -0.453669514 2
      6   -0.809203000 3
      7   -0.624513336 1
      8   -2.539856341 2
      9    1.141915175 3
      10   0.354701622 1
      11  -0.688368818 2
      12  -0.719699407 3
      13  -0.755854353 1
      14  -0.598430725 2
      15  -0.397653243 3
      16  -0.913351714 1
      17  -0.934803691 2
      18   0.965433960 3
      19   0.739327647 1
      20   0.017856999 2
      21  -0.422924993 3
      22  -0.242953247 1
      23   1.760472627 2
      24  -0.611001824 3
      25   0.706534507 1
      26   0.339004648 2
      27   0.463131595 3
      28  -0.530480455 1
      29  -0.692124836 2
      30  -0.314164726 3
      31   0.978400502 1
      32   0.221962161 2
      33  -0.464558660 3
      34  -0.208911112 1
      35  -1.476916118 2
      36  -0.827003547 3
      37   0.425585038 1
      38  -0.682024001 2
      39  -0.562822783 3
      40  -1.721077417 1
      41  -0.116454868 2
      42   0.872206785 3
      43   1.180526289 1
      44  -0.171554747 2
      45  -3.386572977 3
      46  -0.095081732 1
      47  -0.083791274 2
      48   0.026950979 3
      49   0.917298262 1
      50   0.355222702 2
      51   0.687454442 3
      52   0.415238823 1
      53  -0.258516105 2
      54   0.003276876 3
      55   0.297221596 1
      56   0.463550607 2
      57  -1.269246334 3
      58   0.362315385 1
      59   0.177677861 2
      60   0.076801167 3
      61   0.126535878 1
      62  -1.382881013 2
      63   0.180870970 3
      64  -0.056631759 1
      65  -0.259661407 2
      66  -0.464544256 3
      67  -0.506880749 1
      68   2.416787430 2
      69   1.502072572 3
      70  -0.795912989 1
      71  -0.011096607 2
      72  -0.004186388 3
      73  -0.258675245 1
      74   1.313974015 2
      75   0.156927685 3
      76   0.184002278 1
      77   0.593782504 2
      78  -0.269563210 3
      79  -0.974271692 1
      80  -0.806384070 2
      81   3.059689293 3
      82   0.404490659 1
      83   1.143103290 2
      84  -0.032118106 3
      85   0.266122983 1
      86   1.380550339 2
      87   0.152129386 3
      88   1.705747171 1
      89   0.434266314 2
      90  -0.100437274 3
      91  -0.249522260 1
      92  -0.120563744 2
      93  -0.431221954 3
      94   0.607318502 1
      95   0.199807551 2
      96  -0.183284993 3
      97  -1.160146445 1
      98  -2.766040803 2
      99  -0.434224273 3
      100  0.402791869 1
      101  0.042305988 2
      102  0.572204223 3
      103 -1.265321608 1
      104 -0.342999090 2
      105 -0.998542478 3
      106 -0.116777875 1
      107  0.757147128 2
      108 -0.423360506 3
      109 -0.367000434 1
      110 -0.256467593 2
      111  2.078055407 3
      112  0.178649235 1
      113 -2.318314017 2
      114  0.125268187 3
      115  0.283929435 1
      116  0.254819296 2
      117 -0.582136150 3
      118  1.940498809 1
      119 -1.028683677 2
      120  2.639687267 3
      121 -0.101786737 1
      122  0.664410001 2
      123  0.606340779 3
      124  0.761244917 1
      125 -0.397838413 2
      126 -0.046363538 3
      127 -0.365315735 1
      128 -0.005496924 2
      129 -0.370877049 3
      130  0.172136147 1
      131 -1.376153178 2
      132  0.077888113 3
      133 -0.335384630 1
      134  0.061106774 2
      135 -1.132360491 3
      136  0.172501054 1
      137 -0.982290738 2
      138  1.145652751 3
      139  1.059555957 1
      140 -1.181261977 2
      141 -0.404165412 3
      142  1.836137005 1
      143 -0.038343465 2
      144  0.140194564 3
      145  0.102084061 1
      146  0.408567971 2
      147  0.062379790 3
      148  0.773770815 1
      149  0.706443981 2
      150  0.156473447 3

