% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated-get.predplot.r
\name{get.predplot-deprecated}
\alias{get.predplot-deprecated}
\alias{get.predplot}
\title{Create a default map from predictions}
\usage{
get.predplot(x)
}
\arguments{
\item{x}{the output of the \code{\link{predict.slmfit}()} function, of class \code{predict.slmfit}}
}
\value{
a plot with x-coordinates on the x-axis and y-coordinates on the y-axis that is coloured by predictions, with points with an X denoting that a site was sampled and filled circles denoting unsampled sites.
}
\description{
Creates a default map for the predictions of unobserved sites. Note that all predictions are stored
in a data frame in the output of \code{\link{predict.slmfit}()}. Therefore, if a user
would like to create his or her own plot, he or she can easily do so using
this data frame.
}
\examples{
data(exampledataset) ## load a toy data set
slmobj <- slmfit(formula = counts ~ pred1 + pred2, data = exampledataset,
xcoordcol = 'xcoords', ycoordcol = 'ycoords', areacol = 'areavar')
predobj <- predict(slmobj)
## Not Run
## get.predplot(predobj)
}
