% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma_test.R
\name{gamma_test}
\alias{gamma_test}
\title{Estimate Smoothness in an Input/output Dataset}
\usage{
gamma_test(
  predictors,
  target,
  n_neighbors = 10,
  eps = 0,
  plot = FALSE,
  caption = "",
  verbose = FALSE
)
}
\arguments{
\item{predictors}{A Numeric vector or matrix whose columns are proposed inputs to a predictive function.}

\item{target}{A Numeric vector, the output variable that is to be predicted}

\item{n_neighbors}{An Integer, the number of near neighbors to use in calculating gamma}

\item{eps}{The error term passed to the approximate near neighbor search.  The default value
of zero means that exact near neighbors will be found, but time will be O(M^2), where an
approximate search can run in O(M*log(M))}

\item{plot}{A Logical variable, whether to plot the delta/gamma graph.}

\item{caption}{A character string which will be the caption for the plot if plot = TRUE}

\item{verbose}{A Logical variable, whether to return details of the computation}
}
\value{
If verbose == FALSE, a list containing Gamma and the vratio, If verbose == TRUE,
that list plus the distances from each point to its near neighbors, the average of squared distances,
and the value returned by lm on the delta and gamma averages.  Gamma is Coefficient 1 of lm.
}
\description{
The gamma test measures mean squared error in an input/output data set, relative
to an arbitrary, unknown smooth function.  This can usually be interpreted as testing
for the existence of a causal relationship, and estimating the expected error of the
best smooth model that could be built on that relationship.
}
\examples{
he <- embed(henon_x, 3)
t <- he[ , 1]
p <- he[ ,2:3]
gamma_test(predictors = p, target = t)
}
\references{
\url{https://royalsocietypublishing.org/doi/10.1098/rspa.2002.1010},
\url{https://link.springer.com/article/10.1007/s10287-003-0006-1},
\url{https://smoothregression.com}
}
