% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csiro_chlorine_marine.R
\docType{data}
\name{csiro_chlorine_marine}
\alias{csiro_chlorine_marine}
\title{Species Sensitivity Data for chlorine_marine}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl},
\code{data.frame}) with 30 rows and 2 columns.
}
\usage{
csiro_chlorine_marine
}
\description{
Species Sensitivity Data provided by the Commonwealth Scientific and
Industrial Research Organisation of Australia for chlorine in marine water.
}
\details{
These data were sourced from:
\insertRef{Batley2020}{ssddata}

The columns are as follows:

\describe{
\item{Conc}{The chemical concentration (dbl).}
\item{Group}{Taxonomic grouping information (chr).}

Where toxicity measure is not a chronic NEC, EC10 or NOEC value,
concentration has been converted using the appropriate default ratio, as
follows: 10 from acute EC50/LC50 to chronic EC10; 5 from chronic EC50 to
EC10; 2.5 from LOEC to EC10. Please see the primary reference material for
more information.

All concentration data are ug/L unless otherwise stated. }
}
\examples{

print(csiro_chlorine_marine, n=Inf)

}
\keyword{datasets}
