% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals.R
\name{predict_intervals}
\alias{predict_intervals}
\title{GAM confidence and prediction intervals}
\usage{
predict_intervals(object_fit, new_data, n = 1000, CI = TRUE, PI = TRUE, ...)
}
\arguments{
\item{object_fit}{\strong{[gam OR bam]} The fit to use for predictions.}

\item{new_data}{\strong{[data.frame]} The data to predict onto.}

\item{n}{\strong{[numeric]} The number of simulations to run for parameters.}

\item{CI}{\strong{[logical]} Whether to compute the CI.}

\item{PI}{\strong{[logical]} Whether to compute the PI.}

\item{...}{further arguments passed to the quantile function.}
}
\value{
A \code{data.frame} with intervals.
}
\description{
Computes CI from posterior, and PI for Tweedie and scat gams.
}
\examples{
gam1 <- gam(cyl ~ mpg, data=mtcars, family = tw)
predict_intervals(gam1)

}
