% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_nodes.R
\name{delete_nodes}
\alias{delete_nodes}
\title{Delete Nodes from an Event Tree}
\usage{
delete_nodes(
  event_tree_obj,
  nodes_to_delete,
  level_separation = 1000,
  node_distance = 300
)
}
\arguments{
\item{event_tree_obj}{A list containing the event tree object, which includes:
\itemize{
\item \verb{$eventtree$x}: A list with \code{nodes} and \code{edges} data frames.
\item \verb{$filtereddf}: The data frame used to create the event tree.
}}

\item{nodes_to_delete}{A character vector of node IDs to delete from the event tree.}

\item{level_separation}{Numeric value specifying the spacing between levels in the hierarchical layout.
Default is \code{1000}.}

\item{node_distance}{Numeric value specifying the distance between nodes in the layout.
Default is \code{300}.}
}
\value{
A list containing:
\itemize{
\item \verb{$eventtree}: A \code{visNetwork} object representing the updated event tree.
\item \verb{$filtereddf}: The filtered data frame, returned invisibly.
}
}
\description{
This function removes specified nodes from an event tree, updating edges to maintain
the tree structure while ensuring that node IDs remain sequential.
}
\details{
The function performs the following steps:
\itemize{
\item Identifies outgoing and incoming edges for each node marked for deletion.
\item Redirects outgoing edges to the sources of the incoming edges.
\item Updates the edges and nodes data frames to reflect the new connections.
\item Ensures node IDs are sequentially re-assigned.
\item Adjusts outgoing edge counts for affected nodes.
\item Removes orphaned nodes (nodes with no connections).
\item Returns an updated \code{visNetwork} visualization of the event tree.
}
}
\examples{
data <- homicides
event_tree <- create_event_tree(data, columns = c(1,2,4,5), "both")
event_tree

updated_tree <- delete_nodes(event_tree, nodes_to_delete = c("s14", "s18"))
updated_tree

}
