% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/staged_tree_prior.R
\name{staged_tree_prior}
\alias{staged_tree_prior}
\title{Apply Priors to a Staged Tree for Visualization}
\usage{
staged_tree_prior(
  staged_tree_obj,
  prior_table,
  level_separation = 1500,
  node_distance = 250,
  label_type = "priors"
)
}
\arguments{
\item{staged_tree_obj}{A list containing a staged tree object with the components "nodes" and "edges".}

\item{prior_table}{A data frame with columns "Colour", "Level", and "Prior", containing prior distributions for each stage.}

\item{level_separation}{A numeric value determining the separation between levels in the hierarchical layout of the tree. Default is 1000.}

\item{node_distance}{A numeric value for the distance between nodes. Default is 300.}

\item{label_type}{A string indicating the label type for edges. It can be one of "names", "priors", or "priormeans". Default is "names".}
}
\value{
A \code{visNetwork} object that displays the staged tree with adjusted prior distributions and additional information in the tooltips.
}
\description{
This function applies prior distributions to a staged tree, adjusting priors and calculating the mean and variance of the Dirichlet distributions for each node. The function also generates a visualization using the \code{visNetwork} package, showing the tree with additional information like prior distributions, means, and variances.
}
\details{
\itemize{
\item The function assumes that the staged tree object is structured in a specific format, where the nodes and edges are contained in the "stagedtree" component.
\item Priors are adjusted based on the number of nodes in each group, and Dirichlet priors are split and normalized.
\item Tooltips for nodes show the prior distribution, mean, and variance.
\item Edge labels can show the names, priors, or prior means based on the \code{label_type} parameter.
}
}
\examples{
data <- homicides
event_tree <- create_event_tree(data, columns = c(1,2,4,5), "both")
coloured_tree <- ahc_colouring(event_tree)
# cannot run this whole chunk as one, as specify_priors needs user input
tree_priors <- specify_priors(coloured_tree, prior_type = "Uniform", ask_edit = FALSE)
staged_tree <- staged_tree_prior(coloured_tree, tree_priors)
staged_tree

}
