% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{summary.chain_event_graph}
\alias{summary.chain_event_graph}
\title{Summarise a Chain Event Graph Model}
\usage{
\method{summary}{chain_event_graph}(object, ...)
}
\arguments{
\item{object}{An object of class \code{chain_event_graph}, which must contain an \code{update_table} with prior and data columns for each stage.}

\item{...}{Additional arguments (currently unused).}
}
\value{
An invisible object of class \code{summary.chain_event_graph}, which is a list containing:
\describe{
\item{total_log_marginal_likelihood}{Total log marginal likelihood across all stages.}
\item{per_stage_log_scores}{A data frame with log scores and effective sample sizes (ESS) for each stage.}
}
}
\description{
Computes the total log marginal likelihood, effective sample size (ESS), and per-stage log scores for a fitted Chain Event Graph (CEG) model using conjugate prior/posterior updates.
}
\details{
The log marginal likelihood is computed using the Dirichlet-multinomial formula.

The effective sample size for a stage is defined as \eqn{ESS = \sum_j (\alpha_{ij} + y_{ij})}.
It represents the amount of information (prior + observed) available for that stage.
}
\examples{
data <- homicides
event_tree <- create_event_tree(data, columns = c(1,2,4,5), "both")
coloured_tree <- ahc_colouring(event_tree)

# Cannot run this whole chunk at once as specify_priors needs user input
tree_priors <- specify_priors(coloured_tree, prior_type = "Uniform", ask_edit = FALSE)
staged_tree <- staged_tree_prior(coloured_tree, tree_priors)
ceg <- create_ceg(staged_tree, view_table = TRUE)
homicides_CEG_summary <- summary(ceg)

}
