% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/full_indep.R
\name{full_indep}
\alias{full_indep}
\alias{full}
\alias{full.table}
\alias{full.data.frame}
\alias{indep}
\alias{indep.table}
\alias{indep.data.frame}
\title{Full and independent staged event tree}
\usage{
full(
  data,
  order = NULL,
  join_unobserved = TRUE,
  lambda = 0,
  name_unobserved = "UNOBSERVED"
)

\method{full}{table}(
  data,
  order = names(dimnames(data)),
  join_unobserved = TRUE,
  lambda = 0,
  name_unobserved = "UNOBSERVED"
)

\method{full}{data.frame}(
  data,
  order = colnames(data),
  join_unobserved = TRUE,
  lambda = 0,
  name_unobserved = "UNOBSERVED"
)

indep(
  data,
  order = NULL,
  join_unobserved = TRUE,
  lambda = 0,
  name_unobserved = "UNOBSERVED"
)

\method{indep}{table}(
  data,
  order = names(dimnames(data)),
  join_unobserved = TRUE,
  lambda = 0,
  name_unobserved = "UNOBSERVED"
)

\method{indep}{data.frame}(
  data,
  order = colnames(data),
  join_unobserved = TRUE,
  lambda = 0,
  name_unobserved = "UNOBSERVED"
)
}
\arguments{
\item{data}{data to create the model, data.frame or table.}

\item{order}{character vector, order of variables.}

\item{join_unobserved}{logical, if situations with zero observations should
be joined (default TRUE).}

\item{lambda}{smoothing coefficient (default 0).}

\item{name_unobserved}{name to pass to \code{\link{join_unobserved}}.}
}
\description{
Build fitted staged event tree from data.
}
\details{
Functions to create full or independent staged tree models from
data.
The full (or saturated) staged tree is the model where every
situation is in a different stage, and thus the model has the
maximum number of parameters.
Conversely, the independent staged tree (\code{indep}) assigns
all the situations related to the same variable to the same
stage, thus it is equivalent to the independence factorization.
}
\examples{

## full model
DD <- generate_xor_dataset(4, 100)
model_full <- full(DD, lambda = 1)

## independence model (data.frame)
DD <- generate_xor_dataset(4, 100)
model <- indep(DD, lambda = 1)
model
}
