% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/staple_binimg.R
\name{staple_bin_img}
\alias{staple_bin_img}
\alias{staple_multi_img}
\title{Run STAPLE on a set of nifti images}
\usage{
staple_bin_img(x, set_orient = FALSE, verbose = TRUE, ...)

staple_multi_img(x, set_orient = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{x}{Character vector of filenames or list of arrays/images}

\item{set_orient}{Should the orientation be set to the same if the images are
\code{niftiImage}s}

\item{verbose}{print diagnostic messages}

\item{...}{Additional arguments to \code{\link{staple_bin_mat}}}
}
\value{
A list similar to \code{\link{staple_bin_mat}}, but
has a resulting image
}
\description{
Run STAPLE on a set of nifti images
}
\examples{
n = 5
r = 1000
x = lapply(seq(n), function(i) {
   x = rbinom(n = r, size = 1, prob = 0.5)
   array(x, dim = c(10,10, 10))
 })
staple_out = staple_bin_img(x, set_orient = FALSE)
res = staple(x)
testthat::expect_equal(staple_out$sensitivity,
res$sensitivity)

x = lapply(x, RNifti::asNifti, internal = FALSE)
staple_img_out = staple_bin_img(x, set_orient = FALSE)
testthat::expect_equal(staple_out$sensitivity,
staple_img_out$sensitivity)
n = 5
r = 1000
x = lapply(seq(n), function(i) {
   x = rbinom(n = r, size = 5, prob = 0.5)
   array(x, dim = c(10,10, 10))
 })
staple_out = staple_multi_img(x, set_orient = FALSE)
}
