% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createMegaEnv.R
\name{plot.megaEnv}
\alias{plot.megaEnv}
\title{Plot function for class megaEnv}
\usage{
\method{plot}{megaEnv}(
  x,
  ...,
  engine = c("lme4", "asreml"),
  colorGenoBy = NULL,
  title = paste("Scatterplot of mega environments for", x$trait),
  output = TRUE
)
}
\arguments{
\item{x}{An object of class megaEnv.}

\item{...}{Further arguments to be passed on to underlying plot functions.}

\item{engine}{A character string specifying the engine used for making the
predictions on which the plots are based.}

\item{colorGenoBy}{A character string indicating a column in \code{TD} by
which the genotypes in the scatter plots are colored. If \code{NULL} all
genotypes are displayed in black.}

\item{title}{A character string used a title for the plot.}

\item{output}{Should the plot be output to the current device? If
\code{FALSE} only a ggtable object is invisibly returned.}
}
\description{
Function for creating scatter plots of predicted values in computed mega
environments.
}
\examples{
## Compute mega environments for TDMaize.
geMegaEnv <- gxeMegaEnv(TD = TDMaize, trait = "yld")

## Create a scatter plot of predicted values.
plot(geMegaEnv)

}
\seealso{
Other mega environments: 
\code{\link{gxeMegaEnv}()},
\code{\link{predict.megaEnv}()}
}
\concept{mega environments}
