% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain.R
\name{explain}
\alias{explain}
\alias{explain.default}
\alias{explain.htest}
\alias{explain.lm}
\alias{explain.glm}
\alias{explain.polr}
\alias{explain.lme}
\alias{explain.lmerMod}
\alias{explain.glmerMod}
\alias{explain.gam}
\alias{explain.survreg}
\alias{explain.coxph}
\alias{explain.rpart}
\title{Explain statistical output}
\usage{
explain(
  object,
  client,
  context = NULL,
  audience = c("novice", "student", "researcher", "manager", "domain_expert"),
  verbosity = c("moderate", "brief", "detailed"),
  style = c("markdown", "html", "json", "text", "latex"),
  ...
)

\method{explain}{default}(
  object,
  client,
  context = NULL,
  audience = "novice",
  verbosity = "moderate",
  style = "markdown",
  ...
)

\method{explain}{htest}(
  object,
  client,
  context = NULL,
  audience = "novice",
  verbosity = "moderate",
  style = "markdown",
  ...
)

\method{explain}{lm}(
  object,
  client,
  context = NULL,
  audience = "novice",
  verbosity = "moderate",
  style = "markdown",
  ...
)

\method{explain}{glm}(
  object,
  client,
  context = NULL,
  audience = "novice",
  verbosity = "moderate",
  style = "markdown",
  ...
)

\method{explain}{polr}(
  object,
  client,
  context = NULL,
  audience = "novice",
  verbosity = "moderate",
  style = "markdown",
  ...
)

\method{explain}{lme}(
  object,
  client,
  context = NULL,
  audience = "novice",
  verbosity = "moderate",
  style = "markdown",
  ...
)

\method{explain}{lmerMod}(
  object,
  client,
  context = NULL,
  audience = "novice",
  verbosity = "moderate",
  style = "markdown",
  ...
)

\method{explain}{glmerMod}(
  object,
  client,
  context = NULL,
  audience = "novice",
  verbosity = "moderate",
  style = "markdown",
  ...
)

\method{explain}{gam}(
  object,
  client,
  context = NULL,
  audience = "novice",
  verbosity = "moderate",
  style = "markdown",
  ...
)

\method{explain}{survreg}(
  object,
  client,
  context = NULL,
  audience = "novice",
  verbosity = "moderate",
  style = "markdown",
  ...
)

\method{explain}{coxph}(
  object,
  client,
  context = NULL,
  audience = "novice",
  verbosity = "moderate",
  style = "markdown",
  ...
)

\method{explain}{rpart}(
  object,
  client,
  context = NULL,
  audience = "novice",
  verbosity = "moderate",
  style = "markdown",
  ...
)
}
\arguments{
\item{object}{An appropriate statistical object. For example, \code{object} can be
the output from calling \link[stats:t.test]{t.test()} or \link[stats:glm]{glm()}.}

\item{client}{A \link[ellmer:Chat]{Chat} object (e.g., from calling
\link[ellmer:chat_openai]{chat_openai()} or
[chat_gemini()][ellmer::chat_gemini)]).

[ellmer::chat_gemini)]: R:ellmer::chat_gemini)}

\item{context}{Optional character string providing additional context, such
as background on the research question and information about the data.}

\item{audience}{Character string indicating the target audience:
\itemize{
\item \code{"novice"} - Assumes the user has a limited statistics background
(default).
\item \code{"student"} - Assumes the user is learning statistics.
\item \code{"researcher"} - Assumes the user has a strong statistical background and
is familiar with common methodologies.
\item \code{"manager"} - Assumes the user needs high-level insights for
decision-making.
\item \code{"domain_expert"} - Assumes the user is an expert in their own field but
not necessarily in statistics.
}}

\item{verbosity}{Character string indicating the desired verbosity:
\itemize{
\item \code{"moderate"} - Offers a balanced explanation (default).
\item \code{"brief"} - Offers a high-level summary.
\item \code{"detailed"} - Offers a comprehensive interpretation.
}}

\item{style}{Character string indicating the desired output style:
\itemize{
\item \code{"markdown"} (default) - Output formatted as plain Markdown.
\item \code{"html"} - Output formatted as an HTML fragment.
\item \code{"json"} - Output structured as a JSON string parseable into an R list.
\item \code{"text"} - Output as plain text.
\item \code{"latex"} - Output as a LaTeX fragment.
}}

\item{...}{Additional optional arguments. (Currently ignored.)}
}
\value{
An object of class \code{"statlingua_explanation"}. Essentially a list
with the following components:
\itemize{
\item \code{text} - Character string representation of the LLM's response.
\item \code{model_type} - Character string giving the model type (e.g., \code{"lm"} or
\code{"coxph"}).
\item \code{audience} - Character string specifying the level or intended audience for
the explanations.
\item \code{verbosity} - Character string specifying the level of verbosity or level
of detail of the provided explanation.
}
}
\description{
Use an LLM to explain the output from various statistical objects using
straightforward, understandable, and context-aware natural language
descriptions.
}
\examples{
\dontrun{
# Polynomial regression
fm1 <- lm(dist ~ poly(speed, degree = 2), data = cars)
context <- "
The data give the speed of cars (mph) and the distances taken to stop (ft).
Note that the data were recorded in the 1920s!
"
# Use Google Gemini to explain the output; requires an API key; see
# ?ellmer::chat_google_gemini for details
client <- ellmer::chat_google_gemini(echo = "none")
ex <- explain(fm1, client = client, context = context)

# Poisson regression example from ?stats::glm
counts <- c(18,17,15,20,10,20,25,13,12)
outcome <- gl(3,1,9)
treatment <- gl(3,3)
data.frame(treatment, outcome, counts) # showing data
fm2 <- glm(counts ~ outcome + treatment, family = poisson())

# Use Google Gemini to explain the output; requires an API key; see
# ?ellmer::chat_google_gemini for details
client <- ellmer::chat_google_gemini()
explain(fm2, client = client, audience = "student", verbosity = "detailed")
}


}
