% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.median2}
\alias{ci.median2}
\title{Confidence interval for a 2-group median difference}
\usage{
ci.median2(alpha, y1, y2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y1}{vector of scores for group 1}

\item{y2}{vector of scores for group 2}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Median1 - estimated median for group 1
\item Median2 - estimated median for group 2
\item Median1-Median2 - estimated difference of medians
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a distribution-free confidence interval for a difference of population
medians in a 2-group design. Tied scores within each group are assumed to be
rare.
}
\examples{
y1 <- c(32.1, 39.8, 26.3, 35.0, 43.1, 27.0, 40.9, 37.4, 34.0, 29.2)
y2 <- c(36.8, 44.0, 47.1, 42.7, 49.0, 39.6, 46.2, 31.6, 33.1, 48.4)
ci.median2(.05, y1, y2)

# Should return:
#  Median1 Median2 Median1-Median2       SE        LL         UL
#     34.5   43.35           -8.85 4.494993 -17.66002 -0.0399751


}
\references{
\insertRef{Bonett2002}{statpsych}
}
