% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.poisson}
\alias{ci.poisson}
\title{Confidence interval for a Poisson rate}
\usage{
ci.poisson(alpha, f, t)
}
\arguments{
\item{alpha}{alpha value for 1-alpha confidence}

\item{f}{number of event occurences}

\item{t}{time period}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated Poisson rate
\item SE - recovered standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a population Poisson rate. This function
requires the number of occurences (f) of a specific event that were
observed over a specific period of time (t).
}
\details{
The time period (t) does not need to be an integer and can be expressed in
any unit of time such as seconds, hours, or months. The occurances are
assumed to be independent of one another and the unknown occurance rate is
assumed to be constant over time.
}
\examples{
ci.poisson(.05, 23, 5.25)

# Should return:
# Estimate        SE       LL      UL
# 4.380952 0.9684952 2.777148 6.57358
 

}
\references{
\insertRef{Hahn1991}{statpsych}
}
