% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{size.ci.tetra}
\alias{size.ci.tetra}
\title{Sample size for a tetrachoric correlation confidence interval}
\usage{
size.ci.tetra(alpha, p1, p2, cor, w)
}
\arguments{
\item{alpha}{alpha level for 1 - alpha confidence}

\item{p1}{planning value for row 1 marginal proportion}

\item{p2}{planning value for column 1 marginal proportion}

\item{cor}{tetrachoric planning value}

\item{w}{desired confidence interval width}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to estimate a tetrachoric correlation with
desired confidence interval precision. Set the tetrachoric planning value to
the smallest absolute value within a plausible range for a conservatively large
sample size.
}
\examples{
size.ci.tetra(.05, .4, .3, .5, .3)

# Should return:
#  Sample size
#          296


}
\references{
\insertRef{Bonett2005}{statpsych}
}
