% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{size.test.prop2}
\alias{size.test.prop2}
\title{Sample size for a test of a 2-group proportion difference}
\usage{
size.test.prop2(alpha, pow, p1, p2, es)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{pow}{desired power}

\item{p1}{planning value of proportion for group 1}

\item{p2}{planning value of proportion for group 2}

\item{es}{planning value of proportion difference (effect size)}
}
\value{
Returns the required sample size for each group
}
\description{
Computes the sample size in each group required to test a difference in
population proportions with desired power (using a continuity correction) in
a 2-group design. This function requires planning values for both proportions.
Set each proportion planning value to .5 for a conservatively large sample
size requirement. This function does not require the planning value for the
proportion difference (effect size) to equal the difference of the two
proportion planning values; for example, the planning value of the proportion
difference could be set equal to a minimally interesting effect size.
}
\examples{
size.test.prop2(.05, .8, .5, .5, .2)

# Should return:
# Sample size per group
#                   109

size.test.prop2(.05, .8, .3, .1, .2)
# Should return:
# Sample size per group
#                    71


}
