% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mCorrCov.R
\name{mCorrCov}
\alias{mCorrCov}
\title{Correlation & Covariance matrices.}
\usage{
mCorrCov(mcorr, sigma = 1, mu = NULL, coefvar = NULL)
}
\arguments{
\item{mcorr}{a (non-empty) numeric correlation matrix.}

\item{sigma}{an optional vector of standard deviations.}

\item{mu}{an optional vector of means.}

\item{coefvar}{an optional vector of coefficients of variation.}
}
\value{
\code{mCorrCov} gives the covariance matrix for a specified correlation matrix.
}
\description{
Given a correlation matrix and vector of standard deviations (or vector of means and vector of variation coefficients) returns a covariance matrix.
}
\details{
\code{coefvar} = \code{sigma}/\code{mu}.

   If \code{sigma}, \code{mu} or \code{coefvar} are not specified, it´s assumed that default values for standard error's are 1. Length of standard error's is created using number of rows of correlation matrix.
   It's necessary to provide \code{sigma} or \code{mu} and \code{coefvar} (both) in order to obtain a desired covariance matrix.

   Length of vectors is taken using \code{rep}. Pay attention if vectors don't have same length!
}
\examples{
A <- matrix(c(1,2,2,1), nrow = 2, byrow = TRUE)
mCorrCov(A)

B <- matrix(c(1,0.8,0.7,0.8,1,0.55,0.7,0.55,1), nrow = 3, byrow = TRUE)
mCorrCov(B,mu = c(2,3.5,1), coefvar = c(0.3,0.5,0.7))

}
