% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{Parameter}
\alias{Parameter}
\title{A parameter that can be set and used in evaluated code.}
\usage{
Parameter(
  name,
  default,
  id,
  isExtensible,
  isReadonly,
  isRequired,
  isVariadic,
  meta,
  validator,
  value
)
}
\arguments{
\item{name}{The name of the variable. \bold{Required}.}

\item{default}{The default value of the parameter.}

\item{id}{The identifier for this item.}

\item{isExtensible}{Indicates that this parameter is variadic and can accept multiple named arguments.}

\item{isReadonly}{Whether or not a property is mutable. Default is false.}

\item{isRequired}{Is this parameter required, if not it should have a default or default is assumed to be null.}

\item{isVariadic}{Indicates that this parameter is variadic and can accept multiple arguments.}

\item{meta}{Metadata associated with this item.}

\item{validator}{The validator that the value is validated against.}

\item{value}{The value of the variable.}
}
\value{
A \code{list} of class \code{Parameter}
}
\description{
A parameter that can be set and used in evaluated code.
}
\seealso{
\code{\link{Variable}}
}
