% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.stcov.R
\name{print.stcov}
\alias{print.stcov}
\title{Print a \code{stcov} object}
\usage{
\method{print}{stcov}(x, ...)
}
\arguments{
\item{x}{An object of class \code{stcov}}

\item{...}{additional unused argument}
}
\description{
It prints the main information on the spatio-temporal covariate
stored in the \code{stcov} object: the number of points; the enclosing spatial window;
the temporal time period; information on the covariate values.
}
\examples{

set.seed(2)
df <- data.frame(runif(100), runif(100), runif(100), rpois(100, 15))

cov <- stcov(df, interp = FALSE)
cov


}
\author{
Nicoletta D'Angelo
}
