% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srnorm.R
\name{srnorm}
\alias{srnorm}
\alias{srnorm_custom}
\title{Sampling from Normal Distribution}
\usage{
srnorm(n = 1, mean = 0, sd = 1, x = NULL)

srnorm_custom(n = 1, x = NULL)
}
\arguments{
\item{n}{Integer, length 1. Number of samples to draw.}

\item{mean}{Numeric. Mean parameter of the Normal distribution.}

\item{sd}{Numeric. Standard deviation of the target Normal distribution.}

\item{x}{(optional) Numeric vector of length \eqn{n}. If provided, this vector is over
written in place to avoid any memory allocation.}
}
\value{
A numeric vector of length \code{n} containing samples from the Normal distribution with the specified
\code{mean} and \code{sd}.

\bold{NOTE:} When the \code{x} parameter is specified, it is updated in-place with the simulation for performance reasons.
}
\description{
The \code{srnorm()} function generates random samples from a Normal distribution using the STORS algorithm.
It employs an optimized proposal distribution around the mode and Adaptive Rejection Sampling (ARS) for the tails.
}
\details{
The Normal distribution has the probability density function (PDF):
\eqn{f(x | \mu, \sigma) = \frac{1}{\sigma\sqrt{2\pi}} \exp\left(-\frac{(x - \mu)^2}{2\sigma^2}\right),}
where:
\describe{
\item{\eqn{\mu}}{ is the mean of the distribution, which determines the centre of the bell curve.}
\item{\eqn{\sigma}}{ is the standard deviation, which controls the spread of the distribution (\eqn{\sigma > 0}).}
}

These two functions are for sampling using the STORS algorithm based on the proposal that has been constructed using \code{\link{srnorm_optimize}}.

By default, \code{srnorm()} samples from a standard Normal distribution (\code{mean = 0}, \code{sd = 1}).
The proposal distribution is pre-optimized at package load time using \code{srnorm_optimize()} with
\code{steps = 4091}, creating a scalable proposal centred around the mode.

If \code{srnorm()} is called with custom \code{mean} or \code{sd} parameters, the samples are generated
from the standard Normal distribution, then scaled and location shifted accordingly.
}
\examples{
# Generate 10 samples from the standard Normal distribution
samples <- srnorm(10)
print(samples)

# Generate 10 samples using a pre-allocated vector
x <- numeric(10)
srnorm(10, x = x)
print(x)

# Generate 10 samples from a Normal distribution with mean = 2 and sd = 3
samples <- srnorm(10, mean = 2, sd = 3)
print(samples)

}
\seealso{
\code{\link{srnorm_optimize}} to optimize the custom or the scaled proposal.
}
