% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{d2d}
\alias{d2d}
\title{Data-Frame to Data-Frame (e.g., factors to character vectors)}
\usage{
d2d(
  d,
  fct = "chr",
  chr = "chr",
  lgl = "int",
  order.lvl = "alphanum",
  decreasing = FALSE,
  na.lvl = FALSE,
  check = TRUE
)
}
\arguments{
\item{d}{data.frame.}

\item{fct}{character vector of length 1 specifying what factors should be converted
to. There are three options: 1) "chr" for converting to character vectors (i.e.,
factor labels), 2) "int" for converting to integer vectors (i.e., factor codes),
or 3) "fct" for keeping the factor as is without any changes.}

\item{chr}{character vector of length 1 specifying what character vectors should
be converted to. There are three options: 1) "fct" for converting to factors (i.e.,
elements will be factor labels), 2) "int" for converting to integer vectors (i.e.,
factor codes after first converting to a factor), or 3) "chr" for keeping the
character vectors as is without any changes.}

\item{lgl}{character vector of length 1 specifying what logical vectors should
be converted to. There are four options: 1) "fct" for converting to factors (i.e.,
"TRUE" and "FALSE" will be factor labels), 2) "chr" for converting to character
vectors (i.e., elements will be "TRUE" and "FALSE"), 3) "int" for converting to
integer vectors (i.e., TRUE = 1; FALSE = 0), and 4) "lgl" for keeping the logical
vectors as is without any changes.}

\item{order.lvl}{character vector of length 1 specifying how you want to order
the levels of the factor. The options are "alphanum", which sorts the levels
alphanumerically (with NA last); "position", which sorts the levels by the position
the level first appears; "frequency", which sorts the levels by their frequency.
If any frequencies are tied, then the ties are sorted alphanumerically (with NA last).}

\item{decreasing}{logical vector of length 1 specifying whether the ordering of the
levels should be decreasing (TRUE) rather than increasing (FALSE).}

\item{na.lvl}{logical vector of length 1 specifying if NA should be considered a level.}

\item{check}{logical vector of length 1 specifying whether to check the structure
of the input arguments. For example, check whether \code{d} is a data.frame.
This argument is available to allow flexibility in whether the user values
informative error messages (TRUE) vs. computational efficiency (FALSE).}
}
\value{
data.frame with the same dim and dimnames as \code{d}, but with potentially
altered columns which were factors, character vectors, and/or integer vectors.
}
\description{
\code{d2d} converts a data.frame to a modified version of the data.frame. It is
used to convert factors, character vectors, and logical vectors to different
classes/types (e.g., factors to character vectors).
}
\details{
\code{d2d} internally uses the \code{fct2v} and \code{v2fct} functions. See them
or more details about how column conversions work.
}
\examples{
dat <- data.frame(
"lgl_1" = c(TRUE, FALSE, NA),
"lgl_2" = c(FALSE, TRUE, NA),
"int_1" = c(1L, NA, 2L),
"int_2" = c(2L, NA, 1L),
"dbl_1" = c(1.1, NA, 2.2),
"dbl_2" = c(2.2, NA, 1.1),
"chr_1" = c(NA, "a","b"),
"chr_2" = c(NA, "b","a"),
"fct_1" = factor(c(NA, "one","two")),
"fct_2" = factor(c(NA, "two","one"))
)
str(dat)
x <- d2d(dat); str(x) # default
x <- d2d(dat, fct = "fct", chr = "fct", lgl = "fct"); str(x) # all to factors
x <- d2d(dat, fct = "int", chr = "int"); str(x) # all to integers
}
