% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srank.R
\name{srank}
\alias{srank}
\title{Ranking strata.}
\usage{
srank(outcome, strata, weights = NULL, group = NULL)
}
\arguments{
\item{outcome}{A numeric vector of outcome.}

\item{strata}{A vector of \code{length(outcome)} indicating strata
membership. The elements are coerced to factors by
\code{\link[base]{factor}}.}

\item{weights}{An optional vector of weights.}

\item{group}{An optional grouping factor.}
}
\value{
An object of class \code{srank}. \item{raw}{a data frame
  consisting of complete cases of all inputs.} \item{summary}{a data frame
  of stratum-specific information, including name, population
  share, and average percentile rank.}
}
\description{
Ranking strata according to the average percentile rank of members in each
stratum.
}
\examples{
strata_info <- with(cpsmarch2015, srank(income, big_class,
 weights = weight, group = education))
print(strata_info, digits = 3)
}

