% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funnel_plot.R
\name{funnel_plot}
\alias{funnel_plot}
\title{Risk-adjusted funnel plot}
\usage{
funnel_plot(data, ctime, p0, glmmod, followup, predlim = c(0.95, 0.99),
  assist)
}
\arguments{
\item{data}{A \code{data.frame} with rows representing subjects and the
following named columns: \describe{
\item{\code{entrytime}:}{time of entry into study (numeric);}
\item{\code{survtime}:}{time from entry until event (numeric);}
\item{\code{censorid}:}{censoring indicator (0 = right censored, 1 = observed),
(integer);}
\item{\code{unit}:}{integer or character indicating which unit
(f.e. hospital) the observation belongs to.}
} and optionally additional covariates used for risk-adjustment.}

\item{ctime}{Construction time at which the funnel plot
should be determined. Maximum possible time used when not specified.}

\item{p0}{The baseline failure probability at \code{entrytime + followup} for individuals.
If not specified, average failure proportion over whole data is used instead.}

\item{glmmod}{A generalized linear regression model as produced by
the function \code{\link[stats:glm]{glm()}}. Recommended: \cr
\code{glm(as.formula("(survtime <= followup) & (censorid == 1) ~ covariates"), data = data)}. \cr
Alternatively, a list with the following elements:
\describe{
\item{\code{formula}:}{a \code{\link[stats:formula]{formula()}} in the form \code{~ covariates};}
\item{\code{coefficients}:}{a named vector specifying risk adjustment coefficients
for covariates. Names must be the same as in \code{formula} and colnames of \code{data}.}
}}

\item{followup}{The followup time for every individual. At what time
after subject entry do we consider the outcome?}

\item{predlim}{A vector of confidence levels for the prediction limits of interest. Default is c(0.95, 0.99).}

\item{assist}{(optional): Output of the function \code{\link[success:parameter_assist]{parameter_assist()}}}
}
\value{
An object of class "funnelplot" containing:
\itemize{
\item \code{data}: A \code{data.frame} containing:
\describe{
\item{\code{unit}:}{unit number/name;}
\item{\code{observed}:}{observed number of failures at unit;}
\item{\code{expected}:}{expected (risk-adjusted) number of failures at unit;}
\item{\code{numtotal}}{total number of individuals considered at this unit;}
\item{\code{p}:}{(risk-adjusted) proportion of failure at unit;}
\item{\code{predlimels}:}{worse/in-control/better performance than expected at
specified confidence levels.}
}
\item \code{call}: the call used to obtain output
\item \code{plotdata}: data used for plotting confidence intervals
\item \code{predlim}: specified confidence level(s)
\item \code{p0}: (Estimated) baseline failure probability
}
}
\description{
This function allows to construct a risk-adjusted funnel plot
for comparing survival proportion between units, see Spiegelhalter (2005).
}
\examples{
#Determine a risk-adjustment model using a generalized linear model.
#Outcome (survival in first 100 days) is regressed on the available covariates:
exprfitfunnel <- as.formula("(survtime <= 100) & (censorid == 1)~ age + sex + BMI")
glmmodfun <- glm(exprfitfunnel, data = surgerydat, family = binomial(link = "logit"))
#Determine the necessary values to produce a funnel plot
funnel <- funnel_plot(data = surgerydat, ctime = 3*365, glmmod = glmmodfun, followup = 100)
#Produce a funnel plot!
plot(funnel)
\dontrun{
require(plotly)
#Create an interactive plot!
ggplotly(plot(funnel))
}
}
\references{
Spiegelhalter D. J. (2005). Funnel plots for comparing
institutional performance. Statistics in medicine, 24(8), 1185-1202.
\doi{10.1002/sim.1970}
}
\seealso{
\code{\link[success]{plot.funnelplot}}, \code{\link[success]{summary.funnelplot}}

Other quality control charts: 
\code{\link{bk_cusum}()},
\code{\link{cgr_cusum}()}
}
\author{
Daniel Gomon
}
\concept{quality control charts}
