% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safe_rename.R
\name{safe_rename}
\alias{safe_rename}
\title{Safely Rename Columns in a Dataframe}
\usage{
safe_rename(data = NULL, bad_names = NULL, good_names = NULL)
}
\arguments{
\item{data}{(dataframe or dataframe-like) object with column names that match the values passed to the \code{bad_names} argument}

\item{bad_names}{(character) vector of column names to replace in original data object. Order does not need to match data column order but \emph{must} match the \code{good_names} vector order}

\item{good_names}{(character) vector of column names to use as replacements for data object. Order does not need to match data column order but \emph{must} match the \code{good_names} vector order}
}
\value{
(dataframe or dataframe-like) with renamed columns
}
\description{
Replaces specified column names with user-defined vector of new column name(s). This operation is done "safely" because it specifically matches each 'bad' name with its corresponding 'good' name and thus minimizes the risk of accidentally replacing the wrong column name.
}
\examples{
# Make a dataframe to demonstrate
df <- data.frame("first" = 1:3, "middle" = 4:6, "second" = 7:9)

# Invoke the function
supportR::safe_rename(data = df, bad_names = c("second", "middle"),
                      good_names = c("third", "second"))

}
