% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_ave_hr_pi.R, R/calc_hr_pi.R
\name{calc_ave_hr_pi}
\alias{calc_ave_hr_pi}
\alias{calculate_hr_pi}
\alias{calc_hr_pi}
\title{Generate hazard ratio with prediction intervals from parametric bootstrap simulation}
\usage{
calc_ave_hr_pi(
  sim,
  trt,
  group = NULL,
  pi.range = 0.95,
  calc.obs = TRUE,
  trt.assign = c("default", "reverse"),
  simtimelast = NULL,
  boot.subj = TRUE
)

calc_hr_pi(
  sim,
  trt,
  group = NULL,
  pi.range = 0.95,
  calc.obs = TRUE,
  trt.assign = c("default", "reverse")
)
}
\arguments{
\item{sim}{A \code{survparamsim} class object generated by \code{\link[=surv_param_sim]{surv_param_sim()}} function.}

\item{trt}{A string to specify which column define treatment status to calculate HR.}

\item{group}{Optional string(s) to specify grouping variable(s).
You will have faceted histograms for these variables in \code{\link[=plot_hr_pi]{plot_hr_pi()}} function.}

\item{pi.range}{Prediction interval for simulated HR.}

\item{calc.obs}{A logical to specify whether to calculate HR for the observed data.
Need be set as FALSE if survival information in the \code{newdata} is dummy.}

\item{trt.assign}{Specify which of the categories of \code{trt} need to be considered as control group.
See details below if you have more than two categories.}

\item{simtimelast}{An optional numeric to specify duration for average HR calculation.
If NULL (default), the last observation time in the \code{newdata} will be used.}

\item{boot.subj}{Boolean to specify whether bootstrapping of subjects are performed
before calculating HR. Default TRUE.}
}
\description{
Generate hazard ratio with prediction intervals from parametric bootstrap simulation
}
\details{
\code{\link[=calc_hr_pi]{calc_hr_pi()}} calculate hazard ratio using the simulated survival times with Cox proportional hazard
model, while \code{\link[=calc_ave_hr_pi]{calc_ave_hr_pi()}} calculate "average" hazard ratio using the mean survival & probability
density function per treatment groups.

If your \code{trt} has more than two categories/levels and want to specify which one to use as a
reference group, you can convert the column into a factor in the \code{newdata} input for
\code{\link[=surv_param_sim]{surv_param_sim()}}. The first level will be used as a reference group.
}
